library(rearrr)
context("vector_length()")

test_that("testing vector_length()", {
  xpectr::set_test_seed(42)

  expect_equal(vector_length(c(-3, 5, 7)),
               sqrt(sum(c(-3, 5, 7)^2)))


  ## Testing 'vector_length(c(-3, 5, 7))'                                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- vector_length(c(-3, 5, 7))
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    9.11043,
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    1L)
  ## Finished testing 'vector_length(c(-3, 5, 7))'                          ####

  xpectr::set_test_seed(42)

  df <- data.frame(
    "x" = runif(20),
    "y" = runif(20),
    "z" = runif(20),
    stringsAsFactors = FALSE
  )

  # Rowwise
  expect_equal(
    vector_length(df, cols = c("x", "y", "z"))$.vec_len,
    df %>%
      dplyr::rowwise() %>%
      dplyr::summarise(vl = sqrt(sum(c(x, y, z)^2)), .groups = "drop") %>%
      .[["vl"]]
  )

  ## Testing 'vector_length(df, cols = c("x", "y", "z"))$....'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- vector_length(df, cols = c("x", "y", "z"))$.vec_len
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(1.34097, 1.04271, 1.03014, 1.59173, 0.77784, 1.2045, 1.21776,
      1.11717, 1.25467, 1.25657, 0.92992, 1.13805, 1.08767, 1.07259,
      0.46395, 1.46221, 1.18983, 0.2937, 1.05627, 0.97615),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    20L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    20L)
  ## Finished testing 'vector_length(df, cols = c("x", "y", "z"))$....'     ####


  # Colwise
  expect_equal(
    vector_length(df, cols = c("x", "y", "z"), by_row = FALSE) %>%
      as.data.frame(stringsAsFactors = FALSE),
    df %>%
      dplyr::summarise_all(.funs = function(x)sqrt(sum(x^2)))
  )


  ## Testing 'vector_length(df, cols = c("x", "y", "z"), b...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_17148 <- vector_length(df, cols = c("x", "y", "z"), by_row = FALSE)
  # Testing class
  expect_equal(
    class(output_17148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17148[["x"]],
    2.98838,
    tolerance = 1e-4)
  expect_equal(
    output_17148[["y"]],
    2.93397,
    tolerance = 1e-4)
  expect_equal(
    output_17148[["z"]],
    2.70165,
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17148),
    c("x", "y", "z"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17148),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17148),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17148),
    c(1L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'vector_length(df, cols = c("x", "y", "z"), b...'     ####

})

test_that("fuzz testing vector_length()", {
  # Set seed
  xpectr::set_test_seed(42)

  df <- data.frame(
    "x" = runif(20),
    "y" = runif(20),
    "z" = runif(20),
    "ch" = LETTERS[1:20],
    "g" = rep(1:4, each = 5),
    stringsAsFactors = FALSE
  )

  # Generate expectations for 'vector_length'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = vector_length,
  #   args_values = list(
  #     "data" = list(df, dplyr::group_by(df, g), c(1,2,3,4), "hej", 1, NA),
  #     "cols" = list(c("x", "y", "z"), c("x", "y"), c("x", "y", "ch"), "hej", c(NA, NA)),
  #     "by_row" = list(TRUE, FALSE, 1, NA),
  #     "len_col_name" = list(".vec_len", ".vl", 1, NA)
  #   ),
  #   extra_combinations = list(
  #     list("data" = c(1,2,3,4), "cols" = NULL, "by_row" = FALSE)
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'vector_length'                                                  ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing vector_length(data = df, cols = c("x", "y", ...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- vector_length(data = df, cols = c("x", "y", "z"), by_row = TRUE, len_col_name = ".vec_len")
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(0.90403, 0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902,
      0.90574, 0.44697, 0.836, 0.7376, 0.81106, 0.38811, 0.68517,
      0.00395, 0.83292, 0.00733, 0.20766, 0.9066, 0.61178),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["z"]],
    c(0.37956, 0.43577, 0.03743, 0.97354, 0.43175, 0.95758, 0.88775,
      0.63998, 0.97097, 0.61884, 0.33343, 0.34675, 0.39849, 0.78469,
      0.03894, 0.7488, 0.67728, 0.17126, 0.26109, 0.51441),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["ch"]],
    c("A", "B", "C", "D", "E", "F", "G", "H",
      "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T"))
  expect_equal(
    output_19148[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".vec_len"]],
    c(1.34097, 1.04271, 1.03014, 1.59173, 0.77784, 1.2045, 1.21776,
      1.11717, 1.25467, 1.25657, 0.92992, 1.13805, 1.08767, 1.07259,
      0.46395, 1.46221, 1.18983, 0.2937, 1.05627, 0.97615),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", "z", "ch", "g", ".vec_len"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "numeric", "character", "integer", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "double", "character", "integer", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(20L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing vector_length(data = dplyr::group_by(df, g),...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- vector_length(data = dplyr::group_by(df, g), cols = c("x", "y", "z"), by_row = TRUE, len_col_name = ".vec_len")
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["y"]],
    c(0.90403, 0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902,
      0.90574, 0.44697, 0.836, 0.7376, 0.81106, 0.38811, 0.68517,
      0.00395, 0.83292, 0.00733, 0.20766, 0.9066, 0.61178),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["z"]],
    c(0.37956, 0.43577, 0.03743, 0.97354, 0.43175, 0.95758, 0.88775,
      0.63998, 0.97097, 0.61884, 0.33343, 0.34675, 0.39849, 0.78469,
      0.03894, 0.7488, 0.67728, 0.17126, 0.26109, 0.51441),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["ch"]],
    c("A", "B", "C", "D", "E", "F", "G", "H",
      "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T"))
  expect_equal(
    output_19370[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_19370[[".vec_len"]],
    c(1.34097, 1.04271, 1.03014, 1.59173, 0.77784, 1.2045, 1.21776,
      1.11717, 1.25467, 1.25657, 0.92992, 1.13805, 1.08767, 1.07259,
      0.46395, 1.46221, 1.18983, 0.2937, 1.05627, 0.97615),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("x", "y", "z", "ch", "g", ".vec_len"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("numeric", "numeric", "numeric", "character", "integer", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("double", "double", "double", "character", "integer", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(20L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing vector_length(data = c(1, 2, 3, 4), cols = c...
  # Changed from baseline: data = c(1, 2, 3, 4)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(vector_length(data = c(1, 2, 3, 4), cols = c("x", "y", "z"), by_row = TRUE, len_col_name = ".vec_len"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing vector_length(data = "hej", cols = c("x", "y...
  # Changed from baseline: data = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(vector_length(data = "hej", cols = c("x", "y", "z"), by_row = TRUE, len_col_name = ".vec_len"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing vector_length(data = 1, cols = c("x", "y", "...
  # Changed from baseline: data = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(vector_length(data = 1, cols = c("x", "y", "z"), by_row = TRUE, len_col_name = ".vec_len"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing vector_length(data = NA, cols = c("x", "y", ...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(vector_length(data = NA, cols = c("x", "y", "z"), by_row = TRUE, len_col_name = ".vec_len"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip(ifelse(
      is_checkmate_v2_1(),
      "Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Must be of type 'factor', not 'logical'",
      "Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Contains missing values (element 1)"
    )),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing vector_length(data = NULL, cols = c("x", "y"...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(vector_length(data = NULL, cols = c("x", "y", "z"), by_row = TRUE, len_col_name = ".vec_len"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing vector_length(data = c(1, 2, 3, 4), cols = N...
  # Changed from baseline: data, cols, by_row
  xpectr::set_test_seed(42)
  # Assigning output
  output_11346 <- vector_length(data = c(1, 2, 3, 4), cols = NULL, by_row = FALSE, len_col_name = ".vec_len")
  # Testing class
  expect_equal(
    class(output_11346),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_11346,
    type = "double")
  # Testing values
  expect_equal(
    output_11346,
    5.47723,
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_11346),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_11346),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_11346)),
    1L)

  # Testing vector_length(data = df, cols = c("x", "y"),...
  # Changed from baseline: cols = c("x", "y")
  xpectr::set_test_seed(42)
  # Assigning output
  output_16569 <- vector_length(data = df, cols = c("x", "y"), by_row = TRUE, len_col_name = ".vec_len")
  # Testing class
  expect_equal(
    class(output_16569),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16569[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033),
    tolerance = 1e-4)
  expect_equal(
    output_16569[["y"]],
    c(0.90403, 0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902,
      0.90574, 0.44697, 0.836, 0.7376, 0.81106, 0.38811, 0.68517,
      0.00395, 0.83292, 0.00733, 0.20766, 0.9066, 0.61178),
    tolerance = 1e-4)
  expect_equal(
    output_16569[["z"]],
    c(0.37956, 0.43577, 0.03743, 0.97354, 0.43175, 0.95758, 0.88775,
      0.63998, 0.97097, 0.61884, 0.33343, 0.34675, 0.39849, 0.78469,
      0.03894, 0.7488, 0.67728, 0.17126, 0.26109, 0.51441),
    tolerance = 1e-4)
  expect_equal(
    output_16569[["ch"]],
    c("A", "B", "C", "D", "E", "F", "G", "H",
      "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T"))
  expect_equal(
    output_16569[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_16569[[".vec_len"]],
    c(1.28613, 0.94729, 1.02946, 1.2593, 0.64702, 0.73067, 0.83356,
      0.91569, 0.79462, 1.09363, 0.86809, 1.08394, 1.01205, 0.73123,
      0.46231, 1.25594, 0.97825, 0.23859, 1.0235, 0.82961),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_16569),
    c("x", "y", "z", "ch", "g", ".vec_len"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16569),
    c("numeric", "numeric", "numeric", "character", "integer", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16569),
    c("double", "double", "double", "character", "integer", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16569),
    c(20L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16569)),
    character(0),
    fixed = TRUE)

  # Testing vector_length(data = df, cols = c("x", "y", ...
  # Changed from baseline: cols = c("x", "y", "ch")
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(vector_length(data = df, cols = c("x", "y", "ch"), by_row = TRUE, len_col_name = ".vec_len"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable ''cols' columns': May only contain the following types: {numeric}, but element 3 has type\n * 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing vector_length(data = df, cols = "hej", by_ro...
  # Changed from baseline: cols = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(vector_length(data = df, cols = "hej", by_row = TRUE, len_col_name = ".vec_len"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("1 assertions failed:\n * These names in the 'col(s)' argument were not found in 'data': hej."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing vector_length(data = df, cols = c(NA, NA), b...
  # Changed from baseline: cols = c(NA, NA)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(vector_length(data = df, cols = c(NA, NA), by_row = TRUE, len_col_name = ".vec_len"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("Assertion on 'specified column names (NA, NA, \".vec_len\")' failed: Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing vector_length(data = df, cols = NULL, by_row...
  # Changed from baseline: cols = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(vector_length(data = df, cols = NULL, by_row = TRUE, len_col_name = ".vec_len"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("When 'data' is a data.frame, 'cols' must be specified."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing vector_length(data = df, cols = c("x", "y", ...
  # Changed from baseline: by_row = FALSE
  xpectr::set_test_seed(42)
  # Assigning output
  output_12554 <- vector_length(data = df, cols = c("x", "y", "z"), by_row = FALSE, len_col_name = ".vec_len")
  # Testing class
  expect_equal(
    class(output_12554),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12554[["x"]],
    2.98838,
    tolerance = 1e-4)
  expect_equal(
    output_12554[["y"]],
    2.93397,
    tolerance = 1e-4)
  expect_equal(
    output_12554[["z"]],
    2.70165,
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_12554),
    c("x", "y", "z"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12554),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12554),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12554),
    c(1L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12554)),
    character(0),
    fixed = TRUE)

  # Testing vector_length(data = df, cols = c("x", "y", ...
  # Changed from baseline: by_row = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(vector_length(data = df, cols = c("x", "y", "z"), by_row = 1, len_col_name = ".vec_len"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'by_row': Must be of type 'logical flag', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing vector_length(data = df, cols = c("x", "y", ...
  # Changed from baseline: by_row = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(vector_length(data = df, cols = c("x", "y", "z"), by_row = NA, len_col_name = ".vec_len"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'by_row': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing vector_length(data = df, cols = c("x", "y", ...
  # Changed from baseline: by_row = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(vector_length(data = df, cols = c("x", "y", "z"), by_row = NULL, len_col_name = ".vec_len"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'by_row': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing vector_length(data = df, cols = c("x", "y", ...
  # Changed from baseline: len_col_name = ".vl"
  xpectr::set_test_seed(42)
  # Assigning output
  output_11174 <- vector_length(data = df, cols = c("x", "y", "z"), by_row = TRUE, len_col_name = ".vl")
  # Testing class
  expect_equal(
    class(output_11174),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11174[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033),
    tolerance = 1e-4)
  expect_equal(
    output_11174[["y"]],
    c(0.90403, 0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902,
      0.90574, 0.44697, 0.836, 0.7376, 0.81106, 0.38811, 0.68517,
      0.00395, 0.83292, 0.00733, 0.20766, 0.9066, 0.61178),
    tolerance = 1e-4)
  expect_equal(
    output_11174[["z"]],
    c(0.37956, 0.43577, 0.03743, 0.97354, 0.43175, 0.95758, 0.88775,
      0.63998, 0.97097, 0.61884, 0.33343, 0.34675, 0.39849, 0.78469,
      0.03894, 0.7488, 0.67728, 0.17126, 0.26109, 0.51441),
    tolerance = 1e-4)
  expect_equal(
    output_11174[["ch"]],
    c("A", "B", "C", "D", "E", "F", "G", "H",
      "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T"))
  expect_equal(
    output_11174[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_11174[[".vl"]],
    c(1.34097, 1.04271, 1.03014, 1.59173, 0.77784, 1.2045, 1.21776,
      1.11717, 1.25467, 1.25657, 0.92992, 1.13805, 1.08767, 1.07259,
      0.46395, 1.46221, 1.18983, 0.2937, 1.05627, 0.97615),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11174),
    c("x", "y", "z", "ch", "g", ".vl"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11174),
    c("numeric", "numeric", "numeric", "character", "integer", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11174),
    c("double", "double", "double", "character", "integer", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11174),
    c(20L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11174)),
    character(0),
    fixed = TRUE)

  # Testing vector_length(data = df, cols = c("x", "y", ...
  # Changed from baseline: len_col_name = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14749 <- xpectr::capture_side_effects(vector_length(data = df, cols = c("x", "y", "z"), by_row = TRUE, len_col_name = 1), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'len_col_name': Must be of type 'string', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing vector_length(data = df, cols = c("x", "y", ...
  # Changed from baseline: len_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15603 <- xpectr::capture_side_effects(vector_length(data = df, cols = c("x", "y", "z"), by_row = TRUE, len_col_name = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'len_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing vector_length(data = df, cols = c("x", "y", ...
  # Changed from baseline: len_col_name = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19040 <- xpectr::capture_side_effects(vector_length(data = df, cols = c("x", "y", "z"), by_row = TRUE, len_col_name = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'len_col_name': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'vector_length'                                         ####
  #


})
