library(rearrr)
context("dim_values()")

test_that("dim_values()", {
  # Set seed
  xpectr::set_test_seed(42)

  # Create a data frame with clusters
  df <- generate_clusters(
    num_rows = 70,
    num_cols = 3,
    num_clusters = 5,
    compactness = 1.6
  ) %>%
    dplyr::rename(x = D1, y = D2, z = D3) %>%
    dplyr::mutate(o = 1)


  # Generate expectations for 'dim_values'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = dim_values,
  #   args_values = list(
  #     "data" = list(df, c(1, 2, 3, 4, 5, 6), matrix(1:10, nrow = 5, ncol = 2), NA),
  #     "cols" = list(c("x", "y", "o"), c("x", "y"), "x", 1, NA),
  #     "dimming_fn" = list(create_dimming_fn(
  #       numerator = 1,
  #       exponent = 2,
  #       add_to_distance = 1
  #     ),
  #     function(x, d) {
  #       x * d
  #     },
  #     function(x, d) {
  #       c(1, 2)
  #     },
  #     "hej", NA),
  #     "origin" = list(NULL, c(0.5, 0.5, 0.5)),
  #     "origin_fn" = list(centroid, most_centered, mean, function(...) {
  #       c(1, 2, 3)
  #     }),
  #     "dim_col" = list(NULL, "o", "x", "z", 1, NA),
  #     "suffix" = list("", "_dimmed", 1, NA),
  #     "keep_original" = list(FALSE),
  #     "origin_col_name" = list(".origin"),
  #     "overwrite" = list(TRUE, FALSE)
  #   ),
  #   extra_combinations = list(
  #     list("data" = c(1, 2, 3, 4, 5, 6), "cols" = NULL),
  #     list("origin" = c(0.5, 0.5, 0.5), "origin_fn" = NULL),
  #     list("suffix" = "_dimmed", "keep_original" = TRUE),
  #     list("data" = dplyr::group_by(df, .cluster))
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'dim_values'                                                     ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_19148[["x"]], n = 30),
    c(0.94646, 0.90911, 0.87743, 0.66124, 0.52402, 0.66629, 0.70025,
      0.85399, 0.51007, 0.6819, 0.83771, 0.18025, 0.27504, 0.00395,
      0.36316, 0.15342, 0.39183, 0.76435, 0.54875, 0.758, 0.63161,
      0.51492, 0.53551, 0.6892, 0.39242, 0.67491, 0.39426, 0.50697,
      0.24423, 0.26455),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["y"]], n = 30),
    c(0.07029, 0.00116, 0.07542, 0.41716, 0.31661, 0.31597, 0.34816,
      0.4402, 0.43912, 0.41104, 0.37893, 0.69567, 0.64363, 0.72477,
      0.66515, 0.67588, 0.53133, 0.48753, 0.4997, 0.49994, 0.4733,
      0.48136, 0.50523, 0.5076, 0.52666, 0.47906, 0.95892, 0.94618,
      0.90649, 0.91292),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["o"]], n = 30),
    c(0.40014, 0.385, 0.42555, 0.7778, 0.70877, 0.67721, 0.68341, 0.58898,
      0.86025, 0.75091, 0.58623, 0.4931, 0.57743, 0.39226, 0.63604,
      0.48234, 0.73291, 0.68575, 0.98288, 0.69355, 0.85809, 0.9125,
      0.95731, 0.78023, 0.73462, 0.79749, 0.45309, 0.47724, 0.43748,
      0.44154),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", "o", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(70L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing dim_values(data = c(1, 2, 3, 4, 5, 6), cols ...
  # Changed from baseline: data = c(1, 2, 3, 4, ...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19370 <- xpectr::capture_side_effects(dim_values(data = c(1, 2, 3, 4, 5, 6), cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = matrix(1:10, nrow = 5, nco...
  # Changed from baseline: data = matrix(1:10, n...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(dim_values(data = matrix(1:10, nrow = 5, ncol = 2), cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'matrix'\n * checkmate::check_vector(data): Must be of type 'vector', not 'matrix'\n * checkmate::check_factor(data): Must be of type 'factor', not 'matrix'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = NA, cols = c("x", "y", "o"...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(dim_values(data = NA, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Contains missing values (element 1)"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = dplyr::group_by(df, .clust...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_16417 <- dim_values(data = dplyr::group_by(df, .cluster), cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_16417),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_16417[["x"]], n = 30),
    c(0.94646, 0.90911, 0.87743, 0.66124, 0.52402, 0.66629, 0.70025,
      0.85399, 0.51007, 0.6819, 0.83771, 0.18025, 0.27504, 0.00395,
      0.36316, 0.15342, 0.39183, 0.76435, 0.54875, 0.758, 0.63161,
      0.51492, 0.53551, 0.6892, 0.39242, 0.67491, 0.39426, 0.50697,
      0.24423, 0.26455),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_16417[["y"]], n = 30),
    c(0.07029, 0.00116, 0.07542, 0.41716, 0.31661, 0.31597, 0.34816,
      0.4402, 0.43912, 0.41104, 0.37893, 0.69567, 0.64363, 0.72477,
      0.66515, 0.67588, 0.53133, 0.48753, 0.4997, 0.49994, 0.4733,
      0.48136, 0.50523, 0.5076, 0.52666, 0.47906, 0.95892, 0.94618,
      0.90649, 0.91292),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_16417[[".cluster"]], n = 30),
    structure(c(1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 3L,
      3L, 3L, 3L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 5L, 5L,
      5L, 5L), .Label = c("1", "2", "3", "4", "5"), class = "factor"))
  expect_equal(
    xpectr::smpl(output_16417[["o"]], n = 30),
    c(0.84835, 0.88354, 0.93924, 0.86969, 0.69508, 0.86755, 0.94788,
      0.7501, 0.67482, 0.90126, 0.79454, 0.92885, 0.87116, 0.68045,
      0.75128, 0.89623, 0.67164, 0.74905, 0.88913, 0.75756, 0.9394,
      0.83355, 0.86656, 0.85584, 0.67307, 0.87694, 0.93016, 0.79425,
      0.7643, 0.79294),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_16417),
    c("x", "y", ".cluster", "o", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16417),
    c("numeric", "numeric", "factor", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16417),
    c("double", "double", "integer", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16417),
    c(70L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16417)),
    character(0),
    fixed = TRUE)

  # Testing dim_values(data = NULL, cols = c("x", "y", "...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(dim_values(data = NULL, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = c(1, 2, 3, 4, 5, 6), cols ...
  # Changed from baseline: data, cols
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- dim_values(data = c(1, 2, 3, 4, 5, 6), cols = NULL, dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["Index"]],
    c(1, 2, 3, 4, 5, 6),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["Value"]],
    c(0.04861, 0.20528, 1.02944, 1.37258, 0.51321, 0.29167),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17365),
    c("Index", "Value", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("integer", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("integer", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(6L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y"), di...
  # Changed from baseline: cols = c("x", "y")
  xpectr::set_test_seed(42)
  # Assigning output
  output_11346 <- dim_values(data = df, cols = c("x", "y"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_11346),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_11346[["x"]], n = 30),
    c(0.94646, 0.90911, 0.87743, 0.66124, 0.52402, 0.66629, 0.70025,
      0.85399, 0.51007, 0.6819, 0.83771, 0.18025, 0.27504, 0.00395,
      0.36316, 0.15342, 0.39183, 0.76435, 0.54875, 0.758, 0.63161,
      0.51492, 0.53551, 0.6892, 0.39242, 0.67491, 0.39426, 0.50697,
      0.24423, 0.26455),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_11346[["y"]], n = 30),
    c(0.02813, 0.00045, 0.0321, 0.32446, 0.2244, 0.21398, 0.23794, 0.25927,
      0.37775, 0.30865, 0.22214, 0.34304, 0.37165, 0.2843, 0.42306,
      0.326, 0.38942, 0.33432, 0.49115, 0.34673, 0.40613, 0.43924,
      0.48366, 0.39605, 0.38689, 0.38205, 0.43448, 0.45155, 0.39658,
      0.40308),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11346),
    c("x", "y", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11346),
    c("numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11346),
    c("double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11346),
    c(70L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11346)),
    character(0),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = "x", dimming_fn...
  # Changed from baseline: cols = "x"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(dim_values(data = df, cols = "x", dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * This mutator method requires at least 2 dimensions / columns."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = 1, dimming_fn =...
  # Changed from baseline: cols = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(dim_values(data = df, cols = 1, dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("2 assertions failed:\n * This mutator method requires at least 2 dimensions / columns.\n * Variable 'cols': Must be of type 'character', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = NA, dimming_fn ...
  # Changed from baseline: cols = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(dim_values(data = df, cols = NA, dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("Assertion on 'specified column names (NA, \".origin\")' failed: Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = NULL, dimming_f...
  # Changed from baseline: cols = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(dim_values(data = df, cols = NULL, dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("1 assertions failed:\n * This mutator method requires at least 2 dimensions / columns."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: dimming_fn = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = "hej", origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'dimming_fn': Must be a function, not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: dimming_fn = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = NA, origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'dimming_fn': Must be a function, not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: dimming_fn = function...
  xpectr::set_test_seed(42)
  # Assigning output
  output_14622 <- dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = function(x, d) {
      x * d
  }, origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14622),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_14622[["x"]], n = 30),
    c(0.94646, 0.90911, 0.87743, 0.66124, 0.52402, 0.66629, 0.70025,
      0.85399, 0.51007, 0.6819, 0.83771, 0.18025, 0.27504, 0.00395,
      0.36316, 0.15342, 0.39183, 0.76435, 0.54875, 0.758, 0.63161,
      0.51492, 0.53551, 0.6892, 0.39242, 0.67491, 0.39426, 0.50697,
      0.24423, 0.26455),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_14622[["y"]], n = 30),
    c(0.07029, 0.00116, 0.07542, 0.41716, 0.31661, 0.31597, 0.34816,
      0.4402, 0.43912, 0.41104, 0.37893, 0.69567, 0.64363, 0.72477,
      0.66515, 0.67588, 0.53133, 0.48753, 0.4997, 0.49994, 0.4733,
      0.48136, 0.50523, 0.5076, 0.52666, 0.47906, 0.95892, 0.94618,
      0.90649, 0.91292),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_14622[["o"]], n = 30),
    c(0.58086, 0.61164, 0.53295, 0.13388, 0.18781, 0.21518, 0.20965,
      0.30301, 0.07817, 0.154, 0.30607, 0.42407, 0.31598, 0.59665,
      0.25389, 0.43987, 0.16809, 0.20758, 0.00867, 0.20077, 0.07953,
      0.04685, 0.02205, 0.13211, 0.16673, 0.11979, 0.48562, 0.44755,
      0.51188, 0.50493),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14622),
    c("x", "y", "o", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14622),
    c("numeric", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14622),
    c("double", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14622),
    c(70L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14622)),
    character(0),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: dimming_fn = function...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = function(x, d) {
      c(1, 2)
  }, origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("the output of 'dimming_fn' must have the same length as the input."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: dimming_fn = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = NULL, origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'dimming_fn': Must be a function, not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: origin = c(0.5, 0.5, ...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11174 <- xpectr::capture_side_effects(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = c(0.5, 0.5, 0.5), origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_11174 <- xpectr::suppress_mw(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = c(0.5, 0.5, 0.5), origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE))
  # Testing class
  expect_equal(
    class(output_11174),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_11174[["x"]], n = 30),
    c(0.94646, 0.90911, 0.87743, 0.66124, 0.52402, 0.66629, 0.70025,
      0.85399, 0.51007, 0.6819, 0.83771, 0.18025, 0.27504, 0.00395,
      0.36316, 0.15342, 0.39183, 0.76435, 0.54875, 0.758, 0.63161,
      0.51492, 0.53551, 0.6892, 0.39242, 0.67491, 0.39426, 0.50697,
      0.24423, 0.26455),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_11174[["y"]], n = 30),
    c(0.07029, 0.00116, 0.07542, 0.41716, 0.31661, 0.31597, 0.34816,
      0.4402, 0.43912, 0.41104, 0.37893, 0.69567, 0.64363, 0.72477,
      0.66515, 0.67588, 0.53133, 0.48753, 0.4997, 0.49994, 0.4733,
      0.48136, 0.50523, 0.5076, 0.52666, 0.47906, 0.95892, 0.94618,
      0.90649, 0.91292),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_11174[["o"]], n = 30),
    c(0.40014, 0.385, 0.42555, 0.7778, 0.70877, 0.67721, 0.68341, 0.58898,
      0.86025, 0.75091, 0.58623, 0.4931, 0.57743, 0.39226, 0.63604,
      0.48234, 0.73291, 0.68575, 0.98288, 0.69355, 0.85809, 0.9125,
      0.95731, 0.78023, 0.73462, 0.79749, 0.45309, 0.47724, 0.43748,
      0.44154),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11174),
    c("x", "y", "o", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11174),
    c("numeric", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11174),
    c("double", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11174),
    c(70L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11174)),
    character(0),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: origin, origin_fn
  xpectr::set_test_seed(42)
  # Assigning output
  output_14749 <- dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = c(0.5, 0.5, 0.5), origin_fn = NULL, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14749),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_14749[["x"]], n = 30),
    c(0.94646, 0.90911, 0.87743, 0.66124, 0.52402, 0.66629, 0.70025,
      0.85399, 0.51007, 0.6819, 0.83771, 0.18025, 0.27504, 0.00395,
      0.36316, 0.15342, 0.39183, 0.76435, 0.54875, 0.758, 0.63161,
      0.51492, 0.53551, 0.6892, 0.39242, 0.67491, 0.39426, 0.50697,
      0.24423, 0.26455),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_14749[["y"]], n = 30),
    c(0.07029, 0.00116, 0.07542, 0.41716, 0.31661, 0.31597, 0.34816,
      0.4402, 0.43912, 0.41104, 0.37893, 0.69567, 0.64363, 0.72477,
      0.66515, 0.67588, 0.53133, 0.48753, 0.4997, 0.49994, 0.4733,
      0.48136, 0.50523, 0.5076, 0.52666, 0.47906, 0.95892, 0.94618,
      0.90649, 0.91292),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_14749[["o"]], n = 30),
    c(0.30994, 0.30316, 0.32401, 0.42616, 0.42545, 0.4119, 0.41112,
      0.38315, 0.44221, 0.42196, 0.38322, 0.37873, 0.40737, 0.33055,
      0.41944, 0.37487, 0.43711, 0.40792, 0.44304, 0.40953, 0.43413,
      0.44411, 0.44368, 0.4246, 0.43734, 0.42712, 0.35143, 0.35849,
      0.34877, 0.35018),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14749),
    c("x", "y", "o", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14749),
    c("numeric", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14749),
    c("double", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14749),
    c(70L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14749)),
    character(0),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: origin_fn = most_cent...
  xpectr::set_test_seed(42)
  # Assigning output
  output_15603 <- dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = most_centered, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_15603),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_15603[["x"]], n = 30),
    c(0.94646, 0.90911, 0.87743, 0.66124, 0.52402, 0.66629, 0.70025,
      0.85399, 0.51007, 0.6819, 0.83771, 0.18025, 0.27504, 0.00395,
      0.36316, 0.15342, 0.39183, 0.76435, 0.54875, 0.758, 0.63161,
      0.51492, 0.53551, 0.6892, 0.39242, 0.67491, 0.39426, 0.50697,
      0.24423, 0.26455),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_15603[["y"]], n = 30),
    c(0.07029, 0.00116, 0.07542, 0.41716, 0.31661, 0.31597, 0.34816,
      0.4402, 0.43912, 0.41104, 0.37893, 0.69567, 0.64363, 0.72477,
      0.66515, 0.67588, 0.53133, 0.48753, 0.4997, 0.49994, 0.4733,
      0.48136, 0.50523, 0.5076, 0.52666, 0.47906, 0.95892, 0.94618,
      0.90649, 0.91292),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_15603[["o"]], n = 30),
    c(0.3979, 0.38333, 0.42347, 0.77011, 0.71243, 0.67394, 0.6782, 0.58183,
      0.87038, 0.7432, 0.57989, 0.49778, 0.5834, 0.39582, 0.64141,
      0.48711, 0.74307, 0.67635, 1, 0.68386, 0.84638, 0.92726, 0.97192,
      0.76856, 0.74492, 0.78614, 0.45377, 0.47666, 0.43966, 0.44355),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_15603),
    c("x", "y", "o", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_15603),
    c("numeric", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_15603),
    c("double", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_15603),
    c(70L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_15603)),
    character(0),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: origin_fn = mean
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19040 <- xpectr::capture_side_effects(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = mean, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error']]),
    xpectr::strip("output of 'origin_fn' must have same length as 'cols' (3) but had length 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: origin_fn = function(...
  xpectr::set_test_seed(42)
  # Assigning output
  output_11387 <- dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = function(...) {
      c(1, 2, 3)
  }, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_11387),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_11387[["x"]], n = 30),
    c(0.94646, 0.90911, 0.87743, 0.66124, 0.52402, 0.66629, 0.70025,
      0.85399, 0.51007, 0.6819, 0.83771, 0.18025, 0.27504, 0.00395,
      0.36316, 0.15342, 0.39183, 0.76435, 0.54875, 0.758, 0.63161,
      0.51492, 0.53551, 0.6892, 0.39242, 0.67491, 0.39426, 0.50697,
      0.24423, 0.26455),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_11387[["y"]], n = 30),
    c(0.07029, 0.00116, 0.07542, 0.41716, 0.31661, 0.31597, 0.34816,
      0.4402, 0.43912, 0.41104, 0.37893, 0.69567, 0.64363, 0.72477,
      0.66515, 0.67588, 0.53133, 0.48753, 0.4997, 0.49994, 0.4733,
      0.48136, 0.50523, 0.5076, 0.52666, 0.47906, 0.95892, 0.94618,
      0.90649, 0.91292),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_11387[["o"]], n = 30),
    c(0.07, 0.0682, 0.07005, 0.07833, 0.07477, 0.07565, 0.07668, 0.07977,
      0.07786, 0.07828, 0.07804, 0.0805, 0.08057, 0.07835, 0.08222,
      0.07964, 0.07914, 0.08077, 0.07977, 0.08109, 0.07967, 0.07901,
      0.07981, 0.08095, 0.07902, 0.08009, 0.08993, 0.09106, 0.08643,
      0.0869),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11387),
    c("x", "y", "o", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11387),
    c("numeric", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11387),
    c("double", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11387),
    c(70L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11387)),
    character(0),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: origin_fn = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19888 <- xpectr::capture_side_effects(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = NULL, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error']]),
    xpectr::strip("1 assertions failed:\n * At least one of {'origin', 'origin_fn'} must be specified (not 'NULL')."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: dim_col = "o"
  xpectr::set_test_seed(42)
  # Assigning output
  output_19466 <- dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = "o", suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19466),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_19466[["x"]], n = 30),
    c(0.94646, 0.90911, 0.87743, 0.66124, 0.52402, 0.66629, 0.70025,
      0.85399, 0.51007, 0.6819, 0.83771, 0.18025, 0.27504, 0.00395,
      0.36316, 0.15342, 0.39183, 0.76435, 0.54875, 0.758, 0.63161,
      0.51492, 0.53551, 0.6892, 0.39242, 0.67491, 0.39426, 0.50697,
      0.24423, 0.26455),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19466[["y"]], n = 30),
    c(0.07029, 0.00116, 0.07542, 0.41716, 0.31661, 0.31597, 0.34816,
      0.4402, 0.43912, 0.41104, 0.37893, 0.69567, 0.64363, 0.72477,
      0.66515, 0.67588, 0.53133, 0.48753, 0.4997, 0.49994, 0.4733,
      0.48136, 0.50523, 0.5076, 0.52666, 0.47906, 0.95892, 0.94618,
      0.90649, 0.91292),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19466[["o"]], n = 30),
    c(0.40014, 0.385, 0.42555, 0.7778, 0.70877, 0.67721, 0.68341, 0.58898,
      0.86025, 0.75091, 0.58623, 0.4931, 0.57743, 0.39226, 0.63604,
      0.48234, 0.73291, 0.68575, 0.98288, 0.69355, 0.85809, 0.9125,
      0.95731, 0.78023, 0.73462, 0.79749, 0.45309, 0.47724, 0.43748,
      0.44154),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19466),
    c("x", "y", "o", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19466),
    c("numeric", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19466),
    c("double", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19466),
    c(70L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19466)),
    character(0),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: dim_col = "x"
  xpectr::set_test_seed(42)
  # Assigning output
  output_10824 <- dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = "x", suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_10824),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_10824[["y"]], n = 30),
    c(0.07029, 0.00116, 0.07542, 0.41716, 0.31661, 0.31597, 0.34816,
      0.4402, 0.43912, 0.41104, 0.37893, 0.69567, 0.64363, 0.72477,
      0.66515, 0.67588, 0.53133, 0.48753, 0.4997, 0.49994, 0.4733,
      0.48136, 0.50523, 0.5076, 0.52666, 0.47906, 0.95892, 0.94618,
      0.90649, 0.91292),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_10824[["o"]], n = 30),
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_10824[["x"]], n = 30),
    c(0.37872, 0.35001, 0.37339, 0.51431, 0.37141, 0.45122, 0.47856,
      0.50299, 0.43879, 0.51204, 0.49109, 0.08888, 0.15882, 0.00155,
      0.23098, 0.074, 0.28717, 0.52415, 0.53935, 0.52571, 0.54198,
      0.46986, 0.51265, 0.53774, 0.28828, 0.53824, 0.17864, 0.24194,
      0.10685, 0.11681),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_10824),
    c("y", "o", "x", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10824),
    c("numeric", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10824),
    c("double", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10824),
    c(70L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10824)),
    character(0),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: dim_col = "z"
  xpectr::set_test_seed(42)
  # Assigning output
  output_15142 <- dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = "z", suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_15142),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_15142[["x"]], n = 30),
    c(0.94646, 0.90911, 0.87743, 0.66124, 0.52402, 0.66629, 0.70025,
      0.85399, 0.51007, 0.6819, 0.83771, 0.18025, 0.27504, 0.00395,
      0.36316, 0.15342, 0.39183, 0.76435, 0.54875, 0.758, 0.63161,
      0.51492, 0.53551, 0.6892, 0.39242, 0.67491, 0.39426, 0.50697,
      0.24423, 0.26455),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_15142[["y"]], n = 30),
    c(0.07029, 0.00116, 0.07542, 0.41716, 0.31661, 0.31597, 0.34816,
      0.4402, 0.43912, 0.41104, 0.37893, 0.69567, 0.64363, 0.72477,
      0.66515, 0.67588, 0.53133, 0.48753, 0.4997, 0.49994, 0.4733,
      0.48136, 0.50523, 0.5076, 0.52666, 0.47906, 0.95892, 0.94618,
      0.90649, 0.91292),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_15142[["o"]], n = 30),
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_15142[["z"]], n = 30),
    c(0.25875, 0.17836, 0.21296, 0.34338, 0.17433, 0.1883, 0.30203,
      0.17463, 0.34265, 0.2187, 0.195, 0.35817, 0.48271, 0.32168,
      0.59184, 0.46678, 0.07953, 0.06249, 0.23248, 0.16511, 0.21611,
      0.22732, 0.04967, 0.04053, 0.0256, 0.0232, 0.3323, 0.30908,
      0.32079, 0.29949),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_15142),
    c("x", "y", "o", "z", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_15142),
    c("numeric", "numeric", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_15142),
    c("double", "double", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_15142),
    c(70L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_15142)),
    character(0),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: dim_col = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13902 <- xpectr::capture_side_effects(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = 1, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'dim_col': Must be of type 'string' (or 'NULL'), not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: dim_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19057 <- xpectr::capture_side_effects(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NA, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'dim_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: suffix = "_dimmed"
  xpectr::set_test_seed(42)
  # Assigning output
  output_14469 <- dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "_dimmed", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14469),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_14469[["o_dimmed"]], n = 30),
    c(0.40014, 0.385, 0.42555, 0.7778, 0.70877, 0.67721, 0.68341, 0.58898,
      0.86025, 0.75091, 0.58623, 0.4931, 0.57743, 0.39226, 0.63604,
      0.48234, 0.73291, 0.68575, 0.98288, 0.69355, 0.85809, 0.9125,
      0.95731, 0.78023, 0.73462, 0.79749, 0.45309, 0.47724, 0.43748,
      0.44154),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14469),
    c("o_dimmed", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14469),
    c("numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14469),
    c("double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14469),
    c(70L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14469)),
    character(0),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: suffix = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18360 <- xpectr::capture_side_effects(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = 1, keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': Must be of type 'string', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: suffix = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17375 <- xpectr::capture_side_effects(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = NA, keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: suffix = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18110 <- xpectr::capture_side_effects(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = NULL, keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: suffix, keep_original
  xpectr::set_test_seed(42)
  # Assigning output
  output_13881 <- dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "_dimmed", keep_original = TRUE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13881),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_13881[["x"]], n = 30),
    c(0.94646, 0.90911, 0.87743, 0.66124, 0.52402, 0.66629, 0.70025,
      0.85399, 0.51007, 0.6819, 0.83771, 0.18025, 0.27504, 0.00395,
      0.36316, 0.15342, 0.39183, 0.76435, 0.54875, 0.758, 0.63161,
      0.51492, 0.53551, 0.6892, 0.39242, 0.67491, 0.39426, 0.50697,
      0.24423, 0.26455),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_13881[["y"]], n = 30),
    c(0.07029, 0.00116, 0.07542, 0.41716, 0.31661, 0.31597, 0.34816,
      0.4402, 0.43912, 0.41104, 0.37893, 0.69567, 0.64363, 0.72477,
      0.66515, 0.67588, 0.53133, 0.48753, 0.4997, 0.49994, 0.4733,
      0.48136, 0.50523, 0.5076, 0.52666, 0.47906, 0.95892, 0.94618,
      0.90649, 0.91292),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_13881[["z"]], n = 30),
    c(0.64665, 0.46327, 0.50044, 0.44147, 0.24596, 0.27806, 0.44194,
      0.2965, 0.39832, 0.29125, 0.33264, 0.72636, 0.83597, 0.82007,
      0.93051, 0.96773, 0.10851, 0.09113, 0.23652, 0.23806, 0.25185,
      0.24912, 0.05189, 0.05195, 0.03484, 0.02909, 0.7334, 0.64764,
      0.73326, 0.67828),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_13881[[".cluster"]], n = 30),
    structure(c(1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 3L,
      3L, 3L, 3L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 5L, 5L,
      5L, 5L), .Label = c("1", "2", "3", "4", "5"), class = "factor"))
  expect_equal(
    xpectr::smpl(output_13881[["o"]], n = 30),
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_13881[["o_dimmed"]], n = 30),
    c(0.40014, 0.385, 0.42555, 0.7778, 0.70877, 0.67721, 0.68341, 0.58898,
      0.86025, 0.75091, 0.58623, 0.4931, 0.57743, 0.39226, 0.63604,
      0.48234, 0.73291, 0.68575, 0.98288, 0.69355, 0.85809, 0.9125,
      0.95731, 0.78023, 0.73462, 0.79749, 0.45309, 0.47724, 0.43748,
      0.44154),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_13881),
    c("x", "y", "z", ".cluster", "o", "o_dimmed", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13881),
    c("numeric", "numeric", "numeric", "factor", "numeric", "numeric",
      "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13881),
    c("double", "double", "double", "integer", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13881),
    c(70L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13881)),
    character(0),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: keep_original = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16851 <- xpectr::capture_side_effects(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = NULL, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: origin_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_10039 <- dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_10039),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_10039[["x"]], n = 30),
    c(0.94646, 0.90911, 0.87743, 0.66124, 0.52402, 0.66629, 0.70025,
      0.85399, 0.51007, 0.6819, 0.83771, 0.18025, 0.27504, 0.00395,
      0.36316, 0.15342, 0.39183, 0.76435, 0.54875, 0.758, 0.63161,
      0.51492, 0.53551, 0.6892, 0.39242, 0.67491, 0.39426, 0.50697,
      0.24423, 0.26455),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_10039[["y"]], n = 30),
    c(0.07029, 0.00116, 0.07542, 0.41716, 0.31661, 0.31597, 0.34816,
      0.4402, 0.43912, 0.41104, 0.37893, 0.69567, 0.64363, 0.72477,
      0.66515, 0.67588, 0.53133, 0.48753, 0.4997, 0.49994, 0.4733,
      0.48136, 0.50523, 0.5076, 0.52666, 0.47906, 0.95892, 0.94618,
      0.90649, 0.91292),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_10039[["o"]], n = 30),
    c(0.40014, 0.385, 0.42555, 0.7778, 0.70877, 0.67721, 0.68341, 0.58898,
      0.86025, 0.75091, 0.58623, 0.4931, 0.57743, 0.39226, 0.63604,
      0.48234, 0.73291, 0.68575, 0.98288, 0.69355, 0.85809, 0.9125,
      0.95731, 0.78023, 0.73462, 0.79749, 0.45309, 0.47724, 0.43748,
      0.44154),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_10039),
    c("x", "y", "o"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10039),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10039),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10039),
    c(70L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10039)),
    character(0),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: overwrite = FALSE
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18329 <- xpectr::capture_side_effects(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18329[['error']]),
    xpectr::strip("Adding these dimensions would overwrite existing columns: o."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18329[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing dim_values(data = df, cols = c("x", "y", "o"...
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10073 <- xpectr::capture_side_effects(dim_values(data = df, cols = c("x", "y", "o"), dimming_fn = create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1), origin = NULL, origin_fn = centroid, dim_col = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10073[['error']]),
    xpectr::strip("Assertion on 'overwrite' failed: Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10073[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'dim_values'                                            ####
  #

})
