% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{rws_write.environment}
\alias{rws_write.environment}
\title{Write the Data Frames in an Environment to a SQLite Database}
\usage{
\method{rws_write}{environment}(x, exists = TRUE, delete = FALSE,
  replace = FALSE, meta = TRUE, log = TRUE, commit = TRUE,
  strict = TRUE, x_name = substitute(x),
  silent = getOption("rws.silent", FALSE), conn, all = TRUE,
  unique = TRUE, ...)
}
\arguments{
\item{x}{An environment.}

\item{exists}{A flag specifying whether the table(s) must already exist.}

\item{delete}{A flag specifying whether to delete existing rows before 
inserting data. If \code{meta = TRUE} the meta data is deleted.}

\item{replace}{A flag specifying whether to replace any existing rows whose inclusion would violate unique or primary key constraints.}

\item{meta}{A flag specifying whether to preserve meta data.}

\item{log}{A flag specifying whether to log the table operations.}

\item{commit}{A flag specifying whether to commit the operations 
(calling with commit = FALSE can be useful for checking data).}

\item{strict}{A flag specifying whether to error if x has extraneous columns or if exists = TRUE extraneous data frames.}

\item{x_name}{A string of the name of the object.}

\item{silent}{A flag specifying whether to suppress messages and warnings.}

\item{conn}{A \code{\linkS4class{SQLiteConnection}} to a database.}

\item{all}{A flag specifying whether all the existing tables in the data base must be represented.}

\item{unique}{A flag specifying whether each table must represented by no more than one data frame.}

\item{...}{Not used.}
}
\description{
Write the Data Frames in an Environment to a SQLite Database
}
\examples{
conn <- rws_connect()
rws_list_tables(conn)
atable <- readwritesqlite::rws_data
another_table <- readwritesqlite::rws_data
not_atable <- 1L
rws_write(environment(), exists = FALSE, conn = conn)
rws_list_tables(conn)
rws_disconnect(conn)
}
\seealso{
Other rws_write: \code{\link{rws_write.data.frame}},
  \code{\link{rws_write.list}}, \code{\link{rws_write}}
}
\concept{rws_write}
