% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulators.R
\name{sd_simulate}
\alias{sd_simulate}
\title{Simulate a System Dynamics model}
\usage{
sd_simulate(
  ds_inputs,
  start_time = NULL,
  stop_time = NULL,
  timestep = NULL,
  integ_method = "euler"
)
}
\arguments{
\item{ds_inputs}{A list of deSolve inputs generated by read_xmile}

\item{start_time}{A number}

\item{stop_time}{A number}

\item{timestep}{A number}

\item{integ_method}{A string. Either "euler" or "rk4"}
}
\value{
a data frame
}
\description{
Simulate a System Dynamics model
}
\examples{
path      <- system.file("models", "SIR.stmx", package = "readsdr")
ds_inputs <- xmile_to_deSolve(path)
sd_simulate(ds_inputs, 0, 1, 0.25, "rk4")
}
