% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{read_file}
\alias{read_file}
\title{Read a file into a string.}
\usage{
read_file(file, locale = default_locale())
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
   (either a single string or a raw vector).

   Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
   be automatically uncompressed. Files starting with \code{http://},
   \code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
   downloaded. Remote gz files can also be automatically downloaded &
   decompressed.

   Literal data is most useful for examples and tests. It must contain at
   least one new line to be recognised as data (instead of a path).}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link{locale}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}
}
\description{
Read a file into a string.
}
\examples{
read_file(file.path(R.home(), "COPYING"))
}

