% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data_cube.r
\name{download_abs_data_cube}
\alias{download_abs_data_cube}
\title{Experimental helper function to download ABS data cubes that are not compatible with read_abs.}
\usage{
download_abs_data_cube(
  catalogue_string,
  cube,
  path = Sys.getenv("R_READABS_PATH", unset = tempdir())
)
}
\arguments{
\item{catalogue_string}{ABS catalogue name as a string from the ABS website.
For example, Labour Force, Australia, Detailed is "labour-force-australia-detailed".
The possible catalogues can be obtained using the helper function \code{show_available_catalogues()};
or search these catalogues using \code{search_catalogues()},}

\item{cube}{character. A character string that is either the complete filename or (uniquely) in the filename of the data cube you want to
download, e.g. "EQ09". The available filenames can be obtained using the helper function \code{get_available_filenames()}}

\item{path}{Local directory in which downloaded files should be stored. By default, `path`
takes the value set in the environment variable "R_READABS_PATH".
If this variable is not set, any files downloaded
will be stored in a temporary directory (\code{tempdir()}).
See \code{Details} below for  more information.}
}
\description{
\code{download_abs_data_cube()} downloads the latest ABS data cubes based on the catalogue name (from the website url) and cube.
The function downloads the file to disk.
}
\details{
Unlike \code{read_abs()}, this function doesn't import or tidy the data.
Convenience functions are provided to import and tidy key data cubes; see
\code{?read_payrolls()} and \code{?read_lfs_grossflows()}.

`download_abs_data_cube()` downloads an Excel spreadsheet from the ABS.

The file need to be saved somewhere on your disk.
This local directory can be controlled using the `path` argument to
`read_abs()`. If the `path` argument is not set, `read_abs()` will store
the files in a directory set in the "R_READABS_PATH" environment variable.
If this variable isn't set, files will be saved in a temporary directory.

To check the value of the "R_READABS_PATH" variable, run
\code{Sys.getenv("R_READABS_PATH")}. You can set the value of this variable
for a single session using \code{Sys.setenv(R_READABS_PATH = <path>)}.
If you would like to change this variable for all future R sessions, edit
your `.Renviron` file and add \code{R_READABS_PATH = <path>} line.
The easiest way to edit this file is using \code{usethis::edit_r_environ()}.

The filepath is returned invisibly which enables piping to \code{unzip()} or \code{readxl::read_excel}.
}
\examples{

\dontrun{
download_abs_data_cube(
  catalogue_string = "labour-force-australia-detailed",
  cube = "EQ09"
)
}

}
\seealso{
Other data cube functions: 
\code{\link{search_catalogues}()},
\code{\link{show_available_catalogues}()},
\code{\link{show_available_files}()}
}
\concept{data cube functions}
