% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_upload.R
\name{drop_upload}
\alias{drop_upload}
\title{Uploads a file to Dropbox.}
\usage{
drop_upload(
  file,
  path = NULL,
  mode = "overwrite",
  autorename = TRUE,
  mute = FALSE,
  verbose = FALSE,
  dtoken = get_dropbox_token()
)
}
\arguments{
\item{file}{Relative path to local file.}

\item{path}{The relative path on Dropbox where the file should get uploaded.}

\item{mode}{- "add" - will not overwrite an existing file in case of a
conflict. With this mode, when a a duplicate file.txt is uploaded, it  will
become file (2).txt. - "overwrite" will always overwrite a file -}

\item{autorename}{This logical determines what happens when there is a
conflict. If true, the file being uploaded will be automatically renamed to
avoid the conflict. (For example, test.txt might be automatically renamed to
test (1).txt.) The new name can be obtained from the returned metadata. If
false, the call will fail with a 409 (Conflict) response code. The default is `TRUE`}

\item{mute}{Set to FALSE to prevent a notification trigger on the desktop and
mobile apps}

\item{verbose}{By default verbose output is \code{FALSE}. Set to \code{TRUE}
if you need to troubleshoot any output or grab additional parameters.}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}. rdrop2
will try to automatically locate your local credential cache and use them.
However, if the credentials are not found, the function will initiate a new
authentication request. You can override this in \code{\link{drop_auth}} by
pointing to a different location where your credentials are stored.}
}
\description{
This function will allow you to write files of any size to Dropbox(even ones
that cannot be read into memory) by uploading them in chunks.
}
\examples{
\dontrun{
write.csv(mtcars, file = "mtt.csv")
drop_upload("mtt.csv")
}
}
\references{
\href{https://www.dropbox.com/developers/documentation/http/documentation#files-upload}{API documentation}
}
