% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/drop_dir.R
\name{drop_dir}
\alias{drop_dir}
\title{drop_dir}
\usage{
drop_dir(path = NULL, file_limit = 10000, hash = NULL, list = TRUE,
  include_deleted = FALSE, rev = NULL, locale = NULL,
  include_media_info = TRUE, include_membership = FALSE, verbose = FALSE,
  dtoken = get_dropbox_token())
}
\arguments{
\item{path}{This is required The path to the new folder to create relative to
root.}

\item{file_limit}{Default is 10000. (max is 25000). When listing a folder,
the service won't report listings containing more than the specified amount
of files and will instead respond with a 406 (Not Acceptable) status
response.}

\item{hash}{Each call to /metadata on a folder will return a hash field, generated by hashing all of the metadata contained in that response. On later calls to /metadata, you should provide that value via this parameter so that if nothing has changed, the response will be a 304 (Not Modified) status code instead of the full, potentially very large, folder listing. This parameter is ignored if the specified path is associated with a file or if list=false.}

\item{list}{The strings true and false are valid values. true is the default. If true, the folder's metadata will include a contents field with a list of metadata entries for the contents of the folder. If false, the contents field will be omitted.}

\item{include_deleted}{Only applicable when list is set. If this parameter is set to true, then contents will include the metadata of deleted children. Note that the target of the metadata call is always returned even when it has been deleted (with is_deleted set to true) regardless of this flag.}

\item{rev}{If you include a particular revision number, then only the metadata for that revision will be returned.}

\item{locale}{Dropbox uses the locale parameter to specify language settings
of content responses. If your app supports any language other than English,
insert the appropriate IETF language tag. When a supported language is
specified, Dropbox will returned translated size and/or user_error fields
(where applicable)}

\item{include_media_info}{If true, each file will include a photo_info dictionary for photos and a video_info dictionary for videos with additional media info. If the data isn't available yet, the string pending will be returned instead of a dictionary.}

\item{include_membership}{If true, metadata for a shared folder will
include a list of members and a list of groups.}

\item{verbose}{By default verbose output is \code{FALSE}. Set to \code{TRUE}
if you need to troubleshoot any output or grab additional parameters.}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}.
rdrop2 will try to automatically locate your local credential cache and use
them. However, if the credentials are not found, the function will initiate
a new authentication request. You can override this by pointing to a
different location where your credentials are stored.}
}
\description{
Retrieves file and folder metadata.
}
\details{
A sample output for contents returns the following fields:
size, rev, thumb_exists, bytes, modified, client_mtime, path, is_dir, icon, root, mime_type, revision. Note that
with verbose set to FALSE you only get a subset of these fields. To get the full output, look in \code{drop_dir()$contents}
}
\examples{
\dontrun{
drop_dir()
}
}

