% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/drop_file_ops.R
\name{drop_copy}
\alias{drop_copy}
\title{Copies a file or folder to a new location.}
\usage{
drop_copy(from_path = NULL, to_path = NULL, root = "auto",
  verbose = FALSE, dtoken = get_dropbox_token())
}
\arguments{
\item{from_path}{Source file or folder}

\item{to_path}{destination file or folder}

\item{root}{This is required. The root relative to which path is specified.
Valid values are auto (recommended and also the default), sandbox, and dropbox.}

\item{verbose}{By default verbose output is \code{FALSE}. Set to \code{TRUE}
if you need to troubleshoot any output or grab additional parameters.}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}.
rdrop2 will try to automatically locate your local credential cache and use
them. However, if the credentials are not found, the function will initiate
a new authentication request. You can override this by pointing to a
different location where your credentials are stored.}
}
\description{
Copies a file or folder to a new location.
}
\examples{
\dontrun{
write.csv(mtcars, file = "mt.csv")
drop_upload("mt.csv")
drop_create("drop_test2")
drop_copy("mt.csv", "drop_test2/mt2.csv")
}
}

