% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity-components.R
\name{raw_beta}
\alias{raw_beta}
\title{Raw beta (low level diversity component)}
\usage{
raw_beta(meta)
}
\arguments{
\item{meta}{object of class \code{metacommunity}.}
}
\value{
Returns an object of class \code{relativeentropy}.
}
\description{
Calculates the low-level diversity component necessary for calculating raw beta
diversity.
}
\details{
Values generated from \code{raw_beta()} may be input into \code{subdiv()} and
\code{metadiv()} to calculate raw subcommunity/metacommunity beta diversity.
}
\examples{
pop <- data.frame(a = c(1,3), b = c(1,1))
row.names(pop) <- paste0("sp", 1:2)
pop <- pop/sum(pop)
meta <- metacommunity(pop)

# Calculate raw beta component
raw_beta(meta)

}
\references{
Reeve, R., T. Leinster, C. Cobbold, J. Thompson, N. Brummitt, 
S. Mitchell, and L. Matthews. 2014. How to partition diversity. 
arXiv 1404.6520:1–9.
}
