% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_datasets.R
\name{data_and_labels}
\alias{data_and_labels}
\title{Create list of dataset and its variable names}
\usage{
data_and_labels(dataset)
}
\arguments{
\item{dataset}{Any read in dataset created by \code{get_datasets},
either as the file path or after having
been read using \code{readRDS}}
}
\description{
Function to give the former output of get_datasets as it can be nice to have
both the definitions and the dataset attached together
}
\examples{
\dontrun{
# get the model datasets included with the package
model_datasets <- model_datasets

# download one of them
g <- get_datasets(dataset_filenames = model_datasets$FileName[1])
dl <- data_and_labels(g$zzbr62dt)

# now we easily have our survey question labels easily accessible
grep("bed net", dl$variable_names$description, value = TRUE)
}
}
