% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CustomTargetingService.R
\name{dfp_createCustomTargetingValues}
\alias{dfp_createCustomTargetingValues}
\title{createCustomTargetingValues}
\usage{
dfp_createCustomTargetingValues(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createCustomTargetingValuesResponse
}
\description{
Creates new CustomTargetingValue objects. The following fields are required: 
\itemize{
  \item{CustomTargetingValue customTargetingKeyId}
  \item{CustomTargetingValue name}
}
}
\examples{
\dontrun{
request_data <- data.frame(customTargetingKeyId=rep(created_targeting_key$id,2),
                           name=c('TestValue1','TestValue2'), 
                           displayName=c('TestValue1','TestValue2'), 
                           matchType=rep('EXACT', 2))
result <- dfp_createCustomTargetingValues(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/CustomTargetingService#createCustomTargetingValues}{Google Documentation for createCustomTargetingValues}
}
