% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrd_sens_bw.R
\name{mrd_sens_bw}
\alias{mrd_sens_bw}
\title{Bandwidth Sensitivity Simulation for Multivariate Regression Discontinuity}
\usage{
mrd_sens_bw(object, approach = c("center", "univ1", "univ2"), bws)
}
\arguments{
\item{object}{An object returned by \code{mrd_est} or \code{mrd_impute}.}

\item{approach}{A string of the approaches to be refitted, 
choosing from \code{c("center", "univ1", "univ2")}.}

\item{bws}{A positive numeric vector of the bandwidths for refitting an \code{mrd} object.}
}
\value{
\code{mrd_sens_bw} returns a dataframe containing the estimate \code{est}
  and standard error \code{se} 
  for each supplied bandwidth and for the Imbens-Kalyanaraman (2012) optimal bandwidth, \code{bw}, 
  and for each supplied approach, \code{model}. Approaches are either user
  specified (\code{"usr"}) or based on the optimal bandwidth (\code{"origin"}).
}
\description{
\code{mrd_sens_bw} refits the supplied model with varying bandwidths. 
All other aspects of the model are held constant.
}
\examples{
set.seed(12345)
x1 <- runif(10000, -1, 1)
x2 <- rnorm(10000, 10, 2)
cov <- rnorm(10000)
y <- 3 + 2 * x1 + 1 * x2 + 3 * cov + 10 * (x1 >= 0) + 5 * (x2 >= 10) + rnorm(10000)
# front.bw arugment was supplied to speed up the example
# users should choose appropriate values for front.bw
mrd <- mrd_est(y ~ x1 + x2 | cov,
               cutpoint = c(0, 10), t.design = c("geq", "geq"), front.bw=c(1,1,1))
mrd_sens_bw(mrd, approach = "univ1", bws = seq(0.1, 1, length.out = 3))
}
\references{
Imbens, G., Kalyanaraman, K. (2012). 
  Optimal bandwidth choice for the regression discontinuity estimator. 
  The Review of Economic Studies, 79(3), 933-959.
  \url{https://academic.oup.com/restud/article/79/3/933/1533189}.
}
