% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mrd.R
\name{summary.mrd}
\alias{summary.mrd}
\title{Summarize the Multivariate Regression Discontinuity}
\usage{
\method{summary}{mrd}(object, level = 0.95, digits = max(3,
  getOption("digits") - 3), ...)
}
\arguments{
\item{object}{An object of class \code{"mrd"}, usually a result of a call to \code{\link{mrd_est}}.}

\item{level}{Numerical value between 0 and 1. Confidence level for confidence intervals.}

\item{digits}{Number of digits to display.}

\item{...}{Additional arguments.}
}
\value{
\code{summary.mrd} returns a list which has the following components depending on methods
implemented in the \code{"mrd"} object:
\item{center_coefficients}{A matrix containing bandwidths, number of observations, estimates, 
  SEs, confidence intervals, z-values and p-values for each estimated bandwidth.}
\item{univR_coefficients}{A matrix containing bandwidths, number of observations, estimates, 
  SEs, confidence intervals, z-values and p-values for each estimated bandwidth.}
\item{univM_coefficients}{A matrix containing bandwidths, number of observations, estimates, 
  SEs, confidence intervals, z-values and p-values for each estimated bandwidth.}
\item{front_coefficients}{A matrix containing estimates and confidence intervals (if applicable) 
for the complete model.}
\item{front_ht_coefficients}{A matrix containing estimates and confidence intervals (if applicable) 
for the heterogeneous treatment model.}
\item{front_t_coefficients}{A matrix containing estimates and confidence intervals (if applicable) 
for the treatment only model.}
}
\description{
\code{summary.mrd} is a \code{summary} method for class \code{"mrd"}
It is based on \code{\link[rdd]{summary.RD}} function in the \pkg{rdd} package.
}
