% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdb_last_updates.R
\name{rdb_last_updates}
\alias{rdb_last_updates}
\title{Download informations about the last DBnomics updates.}
\usage{
rdb_last_updates(all = FALSE,
  use_readLines = getOption("rdbnomics.use_readLines"))
}
\arguments{
\item{all}{Logical (default \code{FALSE}). If \code{TRUE}, then the entire
dataset of the last updates is retrieved.}

\item{use_readLines}{Logical (default \code{FALSE}). If \code{TRUE}, then
the data are requested and read with the base function \code{readLines}.
This can be used to get round the error \code{Could not resolve host: api.db.nomics.world}.}
}
\value{
A \code{data.frame} or a \code{data.table}.
}
\description{
\code{rdb_last_updates} downloads informations about the last updates from
\href{https://db.nomics.world/}{DBnomics}.
}
\details{
By default, the function returns a \code{data.frame} (or a \code{data.table})
containing the last 100 updates from
\href{https://db.nomics.world/}{DBnomics} with additional informations.
}
\examples{
\dontrun{
rdb_last_updates()

rdb_last_updates(all = TRUE)
}
}
\seealso{
\code{\link{rdb_providers}}
}
