% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdb_by_api_link.R
\name{rdb_by_api_link}
\alias{rdb_by_api_link}
\title{Download DBnomics data using API link.}
\usage{
rdb_by_api_link(api_link,
  use_readLines = getOption("rdbnomics.use_readLines"))
}
\arguments{
\item{api_link}{Character string. DBnomics API link of the search.}

\item{use_readLines}{Logical (default \code{FALSE}). If \code{TRUE}, then
the data are requested and read with the base function \code{readLines}.
This can be used to get round the error \code{Could not resolve host: api.db.nomics.world}.}
}
\value{
A \code{data.frame} or a \code{data.table}.
}
\description{
\code{rdb_by_api_link} downloads data series from
\href{https://db.nomics.world/}{DBnomics}.
}
\details{
This function gives you access to hundreds of millions data series from
\href{https://api.db.nomics.world/}{DBnomics API} (documentation about
the API can be found \href{https://api.db.nomics.world/apidocs}{here}).
The API link is given on the
\href{https://db.nomics.world/}{DBnomics website}.
}
\examples{
\dontrun{
# Fetch two series from different datasets of different providers:
df1 <- rdb_by_api_link(
  paste0(
    'https://api.db.nomics.world/v22/',
    'series?observations=1&series_ids=AMECO/ZUTN/EA19.1.0.0.0.ZUTN,IMF/CPI/A.AT.PCPIT_IX'
  )
)

# Fetch one series from the dataset 'Doing Business' of WB provider:
df2 <- rdb_by_api_link(
  paste0(
    'https://api.db.nomics.world/v22/series/WB/DB?dimensions=\%7B\%22',
    'indicator\%22\%3A\%5B\%22IC.REG.PROC.FE.NO\%22\%5D\%7D&q=Doing\%20Business',
    '&observations=1&format=json&align_periods=1&offset=0&facets=0'
  )
)

# Use readLines before fromJSON to avoid a proxy failure
# Fetch one series from dataset 'Unemployment rate' (ZUTN) of AMECO provider:
options(rdbnomics.use_readLines = TRUE)
df2 <- rdb_by_api_link(
  paste0(
    'https://api.db.nomics.world/v22/series/WB/DB?dimensions=\%7B\%22',
    'indicator\%22\%3A\%5B\%22IC.REG.PROC.FE.NO\%22\%5D\%7D&q=Doing\%20Business',
    '&observations=1&format=json&align_periods=1&offset=0&facets=0'
  )
)
# or
df2 <- rdb_by_api_link(
  paste0(
    'https://api.db.nomics.world/v22/series/WB/DB?dimensions=\%7B\%22',
    'indicator\%22\%3A\%5B\%22IC.REG.PROC.FE.NO\%22\%5D\%7D&q=Doing\%20Business',
    '&observations=1&format=json&align_periods=1&offset=0&facets=0'
  ),
  use_readLines = TRUE
)
}
}
\seealso{
\code{\link{rdb}}
}
