% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/encrypt.R
\name{encrypt}
\alias{encrypt}
\title{Encrypt a File Using GPG.}
\usage{
encrypt(input, output = NULL, passphrase = NULL, compress = "ZLIB",
  cipher = "AES256", armor = FALSE, mdc = TRUE, s2k.mode = 3,
  s2k.digest = "SHA512", s2k.count = 65011712)
}
\arguments{
\item{input}{A character string of the file name you wish to encrypt.}

\item{output}{A character string of the file name that will be created. The default is to create a file with the same name (with an additional \code{.gpg} or \code{.asc} file extension) in the same folder.}

\item{passphrase}{A character string of the passphrase used to decrypt the encrypted file. WARNING: use this to bypass the more secure option of GPG's passphrase popup box. WARNING: the passphrase may be saved in the script as cleartext, saved in the terminal history in cleartext, and/or available in the list of processes in cleartext. The default value is \code{NULL} (Insert the passphrase using GPG's secure pop-up box).}

\item{compress}{A character string of the methods of compression. Possible values are \code{"Uncompressed"}, \code{"ZIP"}, \code{"ZLIB"}, and \code{"BZIP2"}. Values depend on your GPG installation. The default value is \code{"ZLIB"}.}

\item{cipher}{A character string of the encryption algorithm. Possible values are \code{"AES256"}, \code{"Camellia256"}, \code{"TWOFISH"}, \code{"AES128"}, etc. Values depend on your GPG installation. The default value is \code{"AES256"}.}

\item{armor}{\code{TRUE} or \code{FALSE}: flag to produce an encrypted ASCII text output file. The default value is \code{FALSE}.}

\item{mdc}{\code{TRUE} or \code{FALSE}: flag to force the use of modification detection code. It is always used with newer encryption algorithms and recommended to always keep \code{TRUE}. The default value is \code{TRUE}.}

\item{s2k.mode}{An integer 0, 1, or 3. Sets how passphrases are mangled. A value of 0 just uses a plain passphrase (never use). A value of 1 will add a salt to the passphrase. A value of 3 will salt and iterate the passphrase. It is highly recommended to always use 3. The default value is 3.}

\item{s2k.digest}{A character string of the digest algorithm used to mangle passphrases. Possible values are \code{"SHA512"}, \code{"SHA384"}, \code{"SHA256"}, etc. The default value is \code{"SHA512"}.}

\item{s2k.count}{An integer between 1024 and 65011712. Specifies how many times the passphrase mangling is repeated. The default value is 65011712.}
}
\value{
An encrypted file.
}
\description{
Symmetric file encryption using GPG. The \code{encrypt} function defaults to
the strongest cryptographic flags available for GPG.
}
\examples{
\dontrun{
encrypt("path/to/your/file.csv")
encrypt("path/to/your/file.csv", output = "path/to/your/file.csv.gpg")
# WARNING: only use the passphrase argument if you understand why it's
# not secure.
encrypt("path/to/your/file.csv", passphrase = "your-passphrase")
}
}

