% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cr_citation-deprecated}
\alias{cr_citation}
\alias{cr_citation-deprecated}
\title{Lookup article info via CrossRef with DOI and get a citation.}
\usage{
cr_citation(doi, title = FALSE, url = "http://www.crossref.org/openurl/",
  key = "cboettig@gmail.com", ...)
}
\arguments{
\item{doi}{digital object identifier for an article in PLoS Journals}

\item{title}{return the title of the paper or not (defaults to FALSE)}

\item{url}{the PLoS API url for the function (should be left to default)}

\item{key}{your PLoS API key, either enter, or loads from .Rprofile}

\item{...}{Named parameters passed on to \code{\link[httr]{GET}}}
}
\value{
Metadata from DOI in R's bibentry format.
}
\description{
Options to get formatted citations as bibtext or plain text.
}
\details{
See \url{http://labs.crossref.org/openurl/} for more info on this
		Crossref API service.
}
\examples{
\dontrun{
cr_citation(doi="10.1371/journal.pone.0042793")
print(cr_citation("10.3998/3336451.0009.101"), style="Bibtex")
print(cr_citation("10.3998/3336451.0009.101"), style="text")
}
}
\author{
Carl Boettiger \email{cboettig@gmail.com}
}
\seealso{
Use \code{\link{cr_cn}} instead. It does what this function does, and more.
}

