% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Conversion.R
\name{coords.data.frame}
\alias{coords.data.frame}
\title{Create a new data.frame with a given coordinate system}
\usage{
\method{coords}{data.frame}(x, new.coords, ...)
}
\arguments{
\item{x}{a data.frame with columns
labelled x, y, z (for cartesian)
or theta, phi (for spherical colatitude and longitude respectively)}

\item{new.coords}{specifies the new coordinate system
("spherical" or "cartesian").}

\item{...}{Unused arguments.}
}
\value{
A new data.frame whose coordinates are as specified by
\code{new.coords}
}
\description{
This does not affect the original object unless new coordinate system is
directly assigned.
}
\examples{

## Create df with no coords, then create df2 with spherical coords
df <- data.frame(x = c(1,0,0), y = c(0,1,0), z = c(0,0,1))
df

df2 <- coords(df, new.coords = "spherical")
df2


## The function coords does not affect the original object.
## To change the coords assign a new value ("spherical or "cartesian")

coords(df, new.coords = "spherical")
df
coords(df) <- "spherical"
df

}
