% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMBWindowGenerics.R
\name{coords.CMBWindow}
\alias{coords.CMBWindow}
\title{Coordinate system from a \code{\link{CMBWindow}}}
\usage{
\method{coords}{CMBWindow}(x, new.coords, ...)
}
\arguments{
\item{x}{a CMBWindow, \code{win}.}

\item{new.coords}{specifies the new coordinate system
("spherical" or "cartesian")
if a change of coordinate system is desired}

\item{...}{Unused arguments.}
}
\value{
If new.coords is unspecified, then the name of the coordinate system
of \code{win} is returned. Otherwise a new CMBWindow is returned
equivalent to \code{win} but having the desired change of coordinates
}
\description{
This function returns the coordinate system used in a
\code{\link{CMBWindow}}. The coordinate system is either
"cartesian" or "spherical"
}
\details{
If a new coordinate system is specified, using e.g.
new.coords = "spherical", the
coordinate system of the CMBWindow will be converted
}
\examples{
## Create win with sperical coords, then change it to win1 with cartesian coords
win <- CMBWindow(theta = c(0,pi/2,pi/2), phi = c(0,0,pi/2))
coords(win)
win1 <- coords(win, new.coords = "cartesian")
coords(win1)

## Change back to spherical coordinates

coords(win1) <- "spherical"
coords(win1)

}
