% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMBDataFrameGenerics.R
\name{areCompatibleCMBDFs}
\alias{areCompatibleCMBDFs}
\title{Check compatibleness of CMBDataFrames}
\usage{
areCompatibleCMBDFs(cmbdf1, cmbdf2, compare.pix = FALSE)
}
\arguments{
\item{cmbdf1}{a \code{\link{CMBDataFrame}}}

\item{cmbdf2}{a \code{\link{CMBDataFrame}}}

\item{compare.pix}{A boolean. If TRUE then cmbdf1 and
cmbdf2 must share the same pixel indices to be considered
compatible}
}
\description{
Compare attributes to decide if two CMBDataFrames are compatible
}
\details{
If the CMBDataFrames do not have compatible attributes then
a message is printed indicating the attributes that do not match.
To suppress this use the \code{\link{suppressMessages}} function
}
\examples{
a <- CMBDataFrame(nside = 2, ordering = "ring", coords = "cartesian")
b <- CMBDataFrame(nside = 1, ordering = "nested", coords = "spherical")
areCompatibleCMBDFs(a,b)

suppressMessages(areCompatibleCMBDFs(a,b))

}
