% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohenH.r
\name{cohenH}
\alias{cohenH}
\title{Cohen's h to compare proportions for 2 x 2 contingency tables}
\usage{
cohenH(x, observation = "row", verbose = TRUE, digits = 3)
}
\arguments{
\item{x}{A 2 x 2 contingency table.}

\item{observation}{If \code{"row"}, the row constitutes an observation.
That is, the sum of each row is 100 percent.
If \code{"column"}, the column constitutes an observation.  
That is, the sum of each column is 100 percent.}

\item{verbose}{If \code{TRUE}, prints the proportions for each observation.}

\item{digits}{The number of significant digits in the output.}
}
\value{
A single statistic.
}
\description{
Calculates Cohen's h
             for 2 x 2 contingency tables, such as those that 
             might be analyzed with   
             a chi-square test of association.
}
\details{
Cohen's h is an effect size to compare two proportions.
         For a 2 x 2 table: 
         Cohen's h equals Phi2 - Phi1, where,
         If observations are in rows, P1 = a/(a+b) and P2 = c/(c+d).
         If observations are in columns, P1 = a/(a+c) and P2 = b/(b+d).          
         Phi = 2 * asin(sqrt(P))
}
\examples{
data(Pennsylvania18)
Pennsylvania18
cohenH(Pennsylvania18, observation="row")

}
\references{
\url{http://rcompanion.org/handbook/H_05.html}
}
\seealso{
\code{\link{cohenG}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Effect size Cohen h contingency table nominal}
