/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.invariant.ConjugatedPiSystemsDetector;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class RDFProtonDescriptor_G3R
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private static final int G3R_DESC_LENGTH = 13;
    private boolean checkAromaticity = false;
    private IAtomContainer acold = null;
    private IRingSet varRingSet = null;
    private IAtomContainerSet varAtomContainerSet = null;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(RDFProtonDescriptor_G3R.class);
    private static String[] names;

    public RDFProtonDescriptor_G3R() {
        names = new String[13];
        for (int i = 0; i < 13; ++i) {
            RDFProtonDescriptor_G3R.names[i] = "g3r_" + (i + 1);
        }
    }

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#rdfProtonCalculatedValues", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("RDFProtonDescriptor only expects one parameters");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The second parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        DoubleArrayResult result = new DoubleArrayResult(13);
        for (int i = 0; i < 13; ++i) {
            result.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)result, this.getDescriptorNames(), e);
    }

    public DescriptorValue calculate(IAtom atom, IAtomContainer varAtomContainerSet) {
        return this.calculate(atom, varAtomContainerSet, null);
    }

    public DescriptorValue calculate(IAtom atom, IAtomContainer atomContainer, IRingSet precalculatedringset) {
        IAtomContainer varAtomContainer;
        try {
            varAtomContainer = atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(e);
        }
        int atomPosition = atomContainer.indexOf(atom);
        IAtom clonedAtom = varAtomContainer.getAtom(atomPosition);
        DoubleArrayResult rdfProtonCalculatedValues = new DoubleArrayResult(13);
        if (atom.getAtomicNumber() != 1) {
            return this.getDummyDescriptorValue((Exception)((Object)new CDKException("Invalid atom specified")));
        }
        IAtomContainer mol = (IAtomContainer)varAtomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[]{varAtomContainer});
        if (varAtomContainer != this.acold) {
            this.acold = varAtomContainer;
            this.varAtomContainerSet = ConjugatedPiSystemsDetector.detect((IAtomContainer)mol);
            if (precalculatedringset == null) {
                try {
                    this.varRingSet = new AllRingsFinder().findAllRings(varAtomContainer);
                }
                catch (CDKException e) {
                    return this.getDummyDescriptorValue((Exception)((Object)e));
                }
            } else {
                this.varRingSet = precalculatedringset;
            }
            try {
                GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
                peoe.assignGasteigerMarsiliSigmaPartialCharges(mol, true);
            }
            catch (Exception ex1) {
                return this.getDummyDescriptorValue(ex1);
            }
        }
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)varAtomContainer);
                Aromaticity.cdkLegacy().apply(varAtomContainer);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue((Exception)((Object)e));
            }
        }
        for (IBond bond : varAtomContainer.bonds()) {
            IRingSet ringsWithThisBond = this.varRingSet.getRings(bond);
            if (ringsWithThisBond.getAtomContainerCount() <= 0) continue;
            bond.setFlag(2, true);
        }
        for (int w = 0; w < varAtomContainer.getAtomCount(); ++w) {
            IRingSet ringsWithThisAtom = this.varRingSet.getRings(varAtomContainer.getAtom(w));
            if (ringsWithThisAtom.getAtomContainerCount() <= 0) continue;
            varAtomContainer.getAtom(w).setFlag(2, true);
        }
        IAtomContainer detected = this.varAtomContainerSet.getAtomContainer(0);
        List neighboors = mol.getConnectedAtomsList(clonedAtom);
        IAtom neighbour0 = (IAtom)neighboors.get(0);
        List atomsInSecondSphere = mol.getConnectedAtomsList(neighbour0);
        ArrayList<Integer> singles = new ArrayList<Integer>();
        ArrayList<Integer> doubles = new ArrayList<Integer>();
        ArrayList<Integer> atoms = new ArrayList<Integer>();
        ArrayList<Integer> bondsInCycloex = new ArrayList<Integer>();
        for (IAtom curAtomSecond : atomsInSecondSphere) {
            IBond secondBond = mol.getBond(neighbour0, curAtomSecond);
            if (mol.indexOf(curAtomSecond) == atomPosition || !this.getIfBondIsNotRotatable(mol, secondBond, detected)) continue;
            int sphere = 2;
            IBond.Order bondOrder = secondBond.getOrder();
            int bondNumber = mol.indexOf(secondBond);
            boolean theBondIsInA6MemberedRing = false;
            this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.indexOf(curAtomSecond), atoms, sphere, theBondIsInA6MemberedRing);
            List atomsInThirdSphere = mol.getConnectedAtomsList(curAtomSecond);
            if (atomsInThirdSphere.size() <= 0) continue;
            for (IAtom curAtomThird : atomsInThirdSphere) {
                IBond thirdBond = mol.getBond(curAtomThird, curAtomSecond);
                if (mol.indexOf(curAtomThird) == atomPosition || !this.getIfBondIsNotRotatable(mol, thirdBond, detected)) continue;
                sphere = 3;
                bondOrder = thirdBond.getOrder();
                bondNumber = mol.indexOf(thirdBond);
                theBondIsInA6MemberedRing = false;
                if (!thirdBond.getFlag(32) && !curAtomThird.equals((Object)neighbour0)) {
                    IRingSet rsAtom = this.varRingSet.getRings(thirdBond);
                    for (IAtomContainer aRsAtom : rsAtom.atomContainers()) {
                        IRing ring = (IRing)aRsAtom;
                        if (ring.getRingSize() <= 4 || !ring.contains(thirdBond)) continue;
                        theBondIsInA6MemberedRing = true;
                    }
                }
                this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.indexOf(curAtomThird), atoms, sphere, theBondIsInA6MemberedRing);
                theBondIsInA6MemberedRing = false;
                List atomsInFourthSphere = mol.getConnectedAtomsList(curAtomThird);
                if (atomsInFourthSphere.size() <= 0) continue;
                for (IAtom curAtomFourth : atomsInFourthSphere) {
                    IBond fourthBond = mol.getBond(curAtomThird, curAtomFourth);
                    if (mol.indexOf(curAtomFourth) == atomPosition || !this.getIfBondIsNotRotatable(mol, fourthBond, detected)) continue;
                    sphere = 4;
                    bondOrder = fourthBond.getOrder();
                    bondNumber = mol.indexOf(fourthBond);
                    theBondIsInA6MemberedRing = false;
                    this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.indexOf(curAtomFourth), atoms, sphere, theBondIsInA6MemberedRing);
                    List atomsInFifthSphere = mol.getConnectedAtomsList(curAtomFourth);
                    if (atomsInFifthSphere.size() <= 0) continue;
                    for (IAtom curAtomFifth : atomsInFifthSphere) {
                        IBond fifthBond = mol.getBond(curAtomFifth, curAtomFourth);
                        if (mol.indexOf(curAtomFifth) == atomPosition || !this.getIfBondIsNotRotatable(mol, fifthBond, detected)) continue;
                        sphere = 5;
                        bondOrder = fifthBond.getOrder();
                        bondNumber = mol.indexOf(fifthBond);
                        theBondIsInA6MemberedRing = false;
                        this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.indexOf(curAtomFifth), atoms, sphere, theBondIsInA6MemberedRing);
                        List atomsInSixthSphere = mol.getConnectedAtomsList(curAtomFifth);
                        if (atomsInSixthSphere.size() <= 0) continue;
                        for (IAtom curAtomSixth : atomsInSixthSphere) {
                            IBond sixthBond = mol.getBond(curAtomFifth, curAtomSixth);
                            if (mol.indexOf(curAtomSixth) == atomPosition || !this.getIfBondIsNotRotatable(mol, sixthBond, detected)) continue;
                            sphere = 6;
                            bondOrder = sixthBond.getOrder();
                            bondNumber = mol.indexOf(sixthBond);
                            theBondIsInA6MemberedRing = false;
                            this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.indexOf(curAtomSixth), atoms, sphere, theBondIsInA6MemberedRing);
                            List atomsInSeventhSphere = mol.getConnectedAtomsList(curAtomSixth);
                            if (atomsInSeventhSphere.size() <= 0) continue;
                            for (IAtom curAtomSeventh : atomsInSeventhSphere) {
                                IBond seventhBond = mol.getBond(curAtomSeventh, curAtomSixth);
                                if (mol.indexOf(curAtomSeventh) == atomPosition || !this.getIfBondIsNotRotatable(mol, seventhBond, detected)) continue;
                                sphere = 7;
                                bondOrder = seventhBond.getOrder();
                                bondNumber = mol.indexOf(seventhBond);
                                theBondIsInA6MemberedRing = false;
                                this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.indexOf(curAtomSeventh), atoms, sphere, theBondIsInA6MemberedRing);
                            }
                        }
                    }
                }
            }
        }
        Vector3d aA = new Vector3d();
        Vector3d aB = new Vector3d();
        Vector3d bA = new Vector3d();
        Vector3d bB = new Vector3d();
        if (bondsInCycloex.size() > 0) {
            double limitInf = 0.0;
            double limitSup = Math.PI;
            int position = 0;
            double smooth = -2.86;
            double angle = 0.0;
            for (int c = 0; c < 13; ++c) {
                double g3r = limitSup * ((double)c / 13.0);
                double sum = 0.0;
                for (Integer aBondsInCycloex : bondsInCycloex) {
                    int yaCounter = 0;
                    angle = 0.0;
                    double partial = 0.0;
                    position = aBondsInCycloex;
                    IBond theInCycloexBond = mol.getBond(position);
                    IAtom cycloexBondAtom0 = theInCycloexBond.getBegin();
                    IAtom cycloexBondAtom1 = theInCycloexBond.getEnd();
                    List connAtoms = mol.getConnectedAtomsList(cycloexBondAtom0);
                    for (IAtom connAtom : connAtoms) {
                        if (!connAtom.equals((Object)neighbour0)) continue;
                        ++yaCounter;
                    }
                    if (yaCounter > 0) {
                        aA.set(cycloexBondAtom1.getPoint3d().x, cycloexBondAtom1.getPoint3d().y, cycloexBondAtom1.getPoint3d().z);
                        aB.set(cycloexBondAtom0.getPoint3d().x, cycloexBondAtom0.getPoint3d().y, cycloexBondAtom0.getPoint3d().z);
                    } else {
                        aA.set(cycloexBondAtom0.getPoint3d().x, cycloexBondAtom0.getPoint3d().y, cycloexBondAtom0.getPoint3d().z);
                        aB.set(cycloexBondAtom1.getPoint3d().x, cycloexBondAtom1.getPoint3d().y, cycloexBondAtom1.getPoint3d().z);
                    }
                    bA.set(neighbour0.getPoint3d().x, neighbour0.getPoint3d().y, neighbour0.getPoint3d().z);
                    bB.set(atom.getPoint3d().x, atom.getPoint3d().y, atom.getPoint3d().z);
                    angle = this.calculateAngleBetweenTwoLines(aA, aB, bA, bB);
                    partial = Math.exp(smooth * Math.pow(g3r - angle, 2.0));
                    sum += partial;
                }
                rdfProtonCalculatedValues.add(sum);
                LOGGER.debug((Object)("RDF g3r prob.: " + sum + " at distance " + g3r));
            }
        } else {
            return this.getDummyDescriptorValue((Exception)((Object)new CDKException("Some error occurred. Please report")));
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)rdfProtonCalculatedValues, this.getDescriptorNames());
    }

    private boolean getIfBondIsNotRotatable(IAtomContainer mol, IBond bond, IAtomContainer detected) {
        boolean isBondNotRotatable = false;
        int counter = 0;
        IAtom atom0 = bond.getBegin();
        IAtom atom1 = bond.getEnd();
        if (detected != null && detected.contains(bond)) {
            ++counter;
        }
        if (atom0.getFlag(2)) {
            counter = atom1.getFlag(2) ? ++counter : (atom1.getAtomicNumber() == 1 ? ++counter : (counter += 0));
        }
        if (atom0.getAtomicNumber() == 7 && atom1.getAtomicNumber() == 6 && this.getIfACarbonIsDoubleBondedToAnOxygen(mol, atom1)) {
            ++counter;
        }
        if (atom0.getAtomicNumber() == 6 && atom1.getAtomicNumber() == 7 && this.getIfACarbonIsDoubleBondedToAnOxygen(mol, atom0)) {
            ++counter;
        }
        if (counter > 0) {
            isBondNotRotatable = true;
        }
        return isBondNotRotatable;
    }

    private boolean getIfACarbonIsDoubleBondedToAnOxygen(IAtomContainer mol, IAtom carbonAtom) {
        boolean isDoubleBondedToOxygen = false;
        List neighToCarbon = mol.getConnectedAtomsList(carbonAtom);
        int counter = 0;
        for (IAtom neighbour : neighToCarbon) {
            IBond tmpBond;
            if (neighbour.getAtomicNumber() != 8 || (tmpBond = mol.getBond(neighbour, carbonAtom)).getOrder() != IBond.Order.DOUBLE) continue;
            ++counter;
        }
        if (counter > 0) {
            isDoubleBondedToOxygen = true;
        }
        return isDoubleBondedToOxygen;
    }

    private double calculateAngleBetweenTwoLines(Vector3d a, Vector3d b, Vector3d c, Vector3d d) {
        Vector3d firstLine = new Vector3d();
        firstLine.sub((Tuple3d)a, (Tuple3d)b);
        Vector3d secondLine = new Vector3d();
        secondLine.sub((Tuple3d)c, (Tuple3d)d);
        Vector3d firstVec = new Vector3d(firstLine);
        Vector3d secondVec = new Vector3d(secondLine);
        return firstVec.angle(secondVec);
    }

    private void checkAndStore(int bondToStore, IBond.Order bondOrder, ArrayList<Integer> singleVec, ArrayList<Integer> doubleVec, ArrayList<Integer> cycloexVec, int a1, ArrayList<Integer> atomVec, int sphere, boolean isBondInCycloex) {
        if (!atomVec.contains(a1) && sphere < 6) {
            atomVec.add(a1);
        }
        if (!cycloexVec.contains(bondToStore) && isBondInCycloex) {
            cycloexVec.add(bondToStore);
        }
        if (bondOrder == IBond.Order.DOUBLE && !doubleVec.contains(bondToStore)) {
            doubleVec.add(bondToStore);
        }
        if (bondOrder == IBond.Order.SINGLE && !singleVec.contains(bondToStore)) {
            singleVec.add(bondToStore);
        }
    }

    private double calculateDistanceBetweenTwoAtoms(IAtom atom1, IAtom atom2) {
        Point3d firstPoint = atom1.getPoint3d();
        Point3d secondPoint = atom2.getPoint3d();
        double distance = firstPoint.distance(secondPoint);
        return distance;
    }

    private int getNearestBondtoAGivenAtom(IAtomContainer mol, IAtom atom, IBond bond) {
        int nearestBond = 0;
        double distance = 0.0;
        IAtom atom0 = bond.getBegin();
        List bondsAtLeft = mol.getConnectedBondsList(atom0);
        for (int i = 0; i < bondsAtLeft.size(); ++i) {
            IBond curBond = (IBond)bondsAtLeft.get(i);
            double[] values = this.calculateDistanceBetweenAtomAndBond(atom, curBond);
            int partial = mol.indexOf(curBond);
            if (i == 0) {
                nearestBond = mol.indexOf(curBond);
                distance = values[0];
                continue;
            }
            if (!(values[0] < distance)) continue;
            nearestBond = partial;
        }
        return nearestBond;
    }

    private double[] calculateDistanceBetweenAtomAndBond(IAtom proton, IBond theBond) {
        Point3d middlePoint = theBond.get3DCenter();
        Point3d protonPoint = proton.getPoint3d();
        double[] values = new double[]{middlePoint.distance(protonPoint), middlePoint.x, middlePoint.y, middlePoint.z};
        return values;
    }

    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    public Object getParameterType(String name) {
        if (name.equals("checkAromaticity")) {
            return Boolean.TRUE;
        }
        return null;
    }
}

