/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.mcsplus;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.openscience.cdk.smsd.algorithm.mcsplus.MCSPlus;
import org.openscience.cdk.smsd.tools.TimeManager;

@Deprecated
public class BKKCKCF {
    private List<List<Integer>> maxCliquesSet;
    private List<Integer> cEdges;
    private List<Integer> dEdges;
    private int bestCliqueSize;
    private List<Integer> compGraphNodes;
    private double dEdgeIterationSize;
    private double cEdgeIterationSize;

    protected BKKCKCF(List<Integer> compGraphNodesOrg, List<Integer> cEdgesOrg, List<Integer> dEdgesOrg) {
        MCSPlus.setTimeManager(new TimeManager());
        this.compGraphNodes = compGraphNodesOrg;
        this.cEdges = cEdgesOrg;
        this.dEdges = dEdgesOrg;
        this.bestCliqueSize = 0;
        this.dEdgeIterationSize = (double)this.dEdges.size() / 2.0;
        this.cEdgeIterationSize = (double)this.cEdges.size() / 2.0;
        this.maxCliquesSet = new ArrayList<List<Integer>>();
        this.init();
    }

    private void init() {
        ArrayList<Integer> vertex = new ArrayList<Integer>();
        int vertexCount = this.compGraphNodes.size() / 3;
        for (int a = 0; a < vertexCount; ++a) {
            vertex.add(this.compGraphNodes.get(a * 3 + 2));
        }
        vertex.add(0);
        ArrayList<Integer> processedVertex = new ArrayList<Integer>();
        this.initIterator(vertex, processedVertex);
        processedVertex.clear();
    }

    private int enumerateCliques(List<Integer> vertexOfCurrentClique, Stack<Integer> potentialCVertex, List<Integer> potentialDVertex, List<Integer> excludedVertex, List<Integer> excludedCVertex) {
        ArrayList<Integer> potentialVertex = new ArrayList<Integer>();
        for (Integer i : potentialCVertex) {
            potentialVertex.add(i);
        }
        if (potentialCVertex.size() == 1 && excludedVertex.isEmpty()) {
            int cliqueSize = vertexOfCurrentClique.size();
            if (cliqueSize >= this.bestCliqueSize) {
                if (cliqueSize > this.bestCliqueSize) {
                    this.maxCliquesSet.clear();
                    this.bestCliqueSize = cliqueSize;
                }
                if (cliqueSize == this.bestCliqueSize) {
                    this.maxCliquesSet.add(vertexOfCurrentClique);
                }
            }
            return 0;
        }
        this.findCliques(potentialVertex, vertexOfCurrentClique, potentialCVertex, potentialDVertex, excludedVertex, excludedCVertex);
        return 0;
    }

    private List<Integer> findNeighbors(int centralNode) {
        ArrayList<Integer> neighborVertex = new ArrayList<Integer>();
        int a = 0;
        while ((double)a < this.cEdgeIterationSize) {
            if (this.cEdges.get(a * 2 + 0) == centralNode) {
                neighborVertex.add(this.cEdges.get(a * 2 + 1));
                neighborVertex.add(1);
            } else if (this.cEdges.get(a * 2 + 1) == centralNode) {
                neighborVertex.add(this.cEdges.get(a * 2 + 0));
                neighborVertex.add(1);
            }
            ++a;
        }
        a = 0;
        while ((double)a < this.dEdgeIterationSize) {
            if (this.dEdges.get(a * 2 + 0) == centralNode) {
                neighborVertex.add(this.dEdges.get(a * 2 + 1));
                neighborVertex.add(2);
            } else if (this.dEdges.get(a * 2 + 1) == centralNode) {
                neighborVertex.add(this.dEdges.get(a * 2 + 0));
                neighborVertex.add(2);
            }
            ++a;
        }
        return neighborVertex;
    }

    protected int getBestCliqueSize() {
        return this.bestCliqueSize;
    }

    protected Stack<List<Integer>> getMaxCliqueSet() {
        Stack<List<Integer>> solution = new Stack<List<Integer>>();
        solution.addAll(this.maxCliquesSet);
        return solution;
    }

    private void findCliques(List<Integer> potentialVertex, List<Integer> vertexOfCurrentClique, Stack<Integer> potentialCVertex, List<Integer> potentialDVertex, List<Integer> excludedVertex, List<Integer> excludedCVertex) {
        int index = 0;
        ArrayList<Integer> neighbourVertex = new ArrayList();
        while (potentialVertex.get(index) != 0) {
            int potentialVertexIndex = potentialVertex.get(index);
            potentialCVertex.removeElement(potentialVertexIndex);
            ArrayList<Integer> rCopy = new ArrayList<Integer>(vertexOfCurrentClique);
            Stack<Integer> pCopy = new Stack<Integer>();
            ArrayList<Integer> qCopy = new ArrayList<Integer>(potentialDVertex);
            ArrayList<Integer> xCopy = new ArrayList<Integer>(excludedVertex);
            ArrayList<Integer> yCopy = new ArrayList<Integer>(excludedCVertex);
            neighbourVertex.clear();
            for (Integer obj : potentialCVertex) {
                pCopy.add(obj);
            }
            pCopy.pop();
            neighbourVertex = this.findNeighbors(potentialVertexIndex);
            this.groupNeighbors(index, pCopy, qCopy, xCopy, yCopy, neighbourVertex, potentialDVertex, potentialVertex, excludedVertex, excludedCVertex);
            Stack<Integer> pCopyNIntersec = new Stack<Integer>();
            ArrayList<Integer> qCopyNIntersec = new ArrayList<Integer>();
            ArrayList<Integer> xCopyNIntersec = new ArrayList<Integer>();
            ArrayList<Integer> yCopyNIntersec = new ArrayList<Integer>();
            this.copyVertex(neighbourVertex, pCopyNIntersec, pCopy, qCopyNIntersec, qCopy, xCopyNIntersec, xCopy, yCopyNIntersec, yCopy);
            pCopyNIntersec.push(0);
            rCopy.add(potentialVertexIndex);
            this.enumerateCliques(rCopy, pCopyNIntersec, qCopyNIntersec, xCopyNIntersec, yCopyNIntersec);
            excludedVertex.add(potentialVertexIndex);
            ++index;
        }
    }

    private void copyVertex(List<Integer> neighbourVertex, Stack<Integer> pCopyNIntersec, Stack<Integer> pCopy, List<Integer> qCopyNIntersec, List<Integer> qCopy, List<Integer> xCopyNIntersec, List<Integer> xCopy, List<Integer> yCopyNIntersec, List<Integer> yCopy) {
        int nSize = neighbourVertex.size();
        for (int sec = 0; sec < nSize; sec += 2) {
            int nElement = neighbourVertex.get(sec);
            if (pCopy.contains(nElement)) {
                pCopyNIntersec.push(nElement);
            }
            if (qCopy.contains(nElement)) {
                qCopyNIntersec.add(nElement);
            }
            if (xCopy.contains(nElement)) {
                xCopyNIntersec.add(nElement);
            }
            if (!yCopy.contains(nElement)) continue;
            yCopyNIntersec.add(nElement);
        }
    }

    private void groupNeighbors(int index, Stack<Integer> pCopy, List<Integer> qCopy, List<Integer> xCopy, List<Integer> yCopy, List<Integer> neighbourVertex, List<Integer> potentialDVertex, List<Integer> potentialVertex, List<Integer> excludedVertex, List<Integer> excludedCVertex) {
        int nSize = neighbourVertex.size();
        for (int b = 0; b < nSize; b += 2) {
            Integer nElementAtB = neighbourVertex.get(b);
            if (neighbourVertex.get(b + 1) == 1) {
                if (potentialDVertex.contains(nElementAtB)) {
                    pCopy.push(nElementAtB);
                    qCopy.remove(nElementAtB);
                }
                if (excludedCVertex.contains(nElementAtB)) {
                    if (excludedVertex.contains(nElementAtB)) {
                        xCopy.add(nElementAtB);
                    }
                    yCopy.remove(nElementAtB);
                }
            }
            if (potentialVertex.indexOf(nElementAtB) <= index && potentialVertex.contains(nElementAtB)) {
                --index;
            }
            potentialVertex.remove(nElementAtB);
        }
    }

    private void setEdges() {
        boolean dEdgeFlag = false;
        if (this.dEdges.size() > this.cEdges.size()) {
            if (this.dEdges.size() > 10000000 && this.cEdges.size() > 100000) {
                this.dEdgeIterationSize = (double)this.dEdges.size() * 1.0E-6;
                dEdgeFlag = true;
            } else if (this.dEdges.size() > 10000000 && this.cEdges.size() > 5000) {
                this.dEdgeIterationSize = (double)this.dEdges.size() * 0.001;
                dEdgeFlag = true;
            }
        }
        if (dEdgeFlag) {
            this.checkLowestEdgeCount();
        }
    }

    private void initIterator(List<Integer> vertex, List<Integer> processedVertex) {
        ArrayList<Integer> vertexOfCurrentClique = new ArrayList<Integer>();
        Stack<Integer> potentialCVertex = new Stack<Integer>();
        ArrayList<Integer> potentialDVertex = new ArrayList<Integer>();
        ArrayList<Integer> excludedVertex = new ArrayList<Integer>();
        ArrayList<Integer> excludedCVertex = new ArrayList<Integer>();
        int index = 0;
        while (vertex.get(index) != 0) {
            int centralNode = vertex.get(index);
            potentialCVertex.clear();
            potentialDVertex.clear();
            excludedVertex.clear();
            vertexOfCurrentClique.clear();
            List<Integer> neighbourVertex = this.findNeighbors(centralNode);
            for (int c = 0; c < neighbourVertex.size(); c += 2) {
                Integer neighbourVertexOfC = neighbourVertex.get(c);
                if (neighbourVertex.get(c + 1) == 1) {
                    if (processedVertex.contains(neighbourVertexOfC)) {
                        excludedVertex.add(neighbourVertexOfC);
                    } else {
                        potentialCVertex.push(neighbourVertexOfC);
                    }
                } else if (neighbourVertex.get(c + 1) == 2) {
                    if (processedVertex.contains(neighbourVertexOfC)) {
                        excludedCVertex.add(neighbourVertexOfC);
                    } else {
                        potentialDVertex.add(neighbourVertexOfC);
                    }
                }
                if (vertex.indexOf(neighbourVertexOfC) <= index && vertex.contains(neighbourVertexOfC)) {
                    --index;
                }
                vertex.remove(neighbourVertexOfC);
            }
            potentialCVertex.add(0);
            vertexOfCurrentClique.add(centralNode);
            this.enumerateCliques(vertexOfCurrentClique, potentialCVertex, potentialDVertex, excludedVertex, excludedCVertex);
            processedVertex.add(centralNode);
            ++index;
        }
    }

    private void checkLowestEdgeCount() {
        if (this.dEdgeIterationSize < 1.0 && this.cEdges.size() <= 5000) {
            this.dEdgeIterationSize = 2.0;
        } else if (this.dEdgeIterationSize < 1.0) {
            this.dEdgeIterationSize = 1.0;
        }
    }
}

