/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.PubChemCompoundsXMLFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.io.pubchemxml.PubChemXMLHelper;

public class IteratingPCCompoundXMLReader
extends DefaultIteratingChemObjectReader<IAtomContainer> {
    private Reader primarySource;
    private XMLStreamReader parser;
    private PubChemXMLHelper parserHelper;
    private IChemObjectBuilder builder;
    private final XMLInputFactory xmlfact;
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private IAtomContainer nextMolecule;

    public IteratingPCCompoundXMLReader(Reader in, IChemObjectBuilder builder) throws IOException, XMLStreamException {
        this.builder = builder;
        this.parserHelper = new PubChemXMLHelper(builder);
        this.xmlfact = XMLInputFactory.newFactory();
        this.xmlfact.setProperty("javax.xml.stream.isNamespaceAware", true);
        this.parser = this.xmlfact.createXMLStreamReader(in);
        this.primarySource = in;
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    public IteratingPCCompoundXMLReader(InputStream in, IChemObjectBuilder builder) throws Exception {
        this(new InputStreamReader(in), builder);
    }

    @Override
    public IResourceFormat getFormat() {
        return PubChemCompoundsXMLFormat.getInstance();
    }

    @Override
    public boolean hasNext() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = false;
            try {
                if (this.parser.next() == 8) {
                    return false;
                }
                while (this.parser.next() != 8) {
                    if (this.parser.getEventType() != 1 || !this.parser.getLocalName().equals("PC-Compound")) continue;
                    this.hasNext = true;
                    break;
                }
                if (this.hasNext) {
                    this.nextMolecule = this.parserHelper.parseMolecule(this.parser, this.builder);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.hasNext = false;
            }
            if (!this.hasNext) {
                this.nextMolecule = null;
            }
            this.nextAvailableIsKnown = true;
        }
        return this.hasNext;
    }

    @Override
    public IAtomContainer next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextMolecule;
    }

    @Override
    public void close() throws IOException {
        this.primarySource.close();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReader(Reader reader) throws CDKException {
        this.primarySource = reader;
        try {
            this.parser = this.xmlfact.createXMLStreamReader(reader);
        }
        catch (XMLStreamException e) {
            throw new CDKException("Error while opening the input:" + e.getMessage(), e);
        }
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    @Override
    public void setReader(InputStream reader) throws CDKException {
        this.setReader(new InputStreamReader(reader));
    }
}

