/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config.atomtypes;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.BondManipulator;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class OWLAtomTypeHandler
extends DefaultHandler {
    private final String NS_ATOMTYPE = "http://cdk.sf.net/ontologies/atomtypes#";
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(OWLAtomTypeHandler.class);
    private String currentChars;
    private List<IAtomType> atomTypes;
    private IAtomType currentAtomType;
    private int piBondCount;
    private int neighborCount;
    private IBond.Order maxBondOrder;
    private double bondOrderSum;
    private static IChemObjectBuilder builder;

    public OWLAtomTypeHandler(IChemObjectBuilder build) {
        builder = build;
    }

    public List<IAtomType> getAtomTypes() {
        return this.atomTypes;
    }

    @Override
    public void startDocument() {
        this.atomTypes = new ArrayList<IAtomType>();
        this.currentAtomType = null;
    }

    @Override
    public void endElement(String uri, String local, String raw) {
        if ("http://cdk.sf.net/ontologies/atomtypes#".equals(uri)) {
            this.endAtomTypeElement(local);
        }
        this.currentChars = "";
    }

    private void endAtomTypeElement(String local) {
        if ("AtomType".equals(local)) {
            this.atomTypes.add(this.currentAtomType);
            this.currentAtomType.setProperty("cdk:Pi Bond Count", this.piBondCount);
            this.currentAtomType.setFormalNeighbourCount(this.neighborCount);
            if (this.maxBondOrder != IBond.Order.UNSET) {
                this.currentAtomType.setMaxBondOrder(this.maxBondOrder);
            }
            if (this.bondOrderSum > 0.1) {
                this.currentAtomType.setBondOrderSum(this.bondOrderSum);
            }
        } else if ("formalCharge".equals(local)) {
            if (this.currentChars.charAt(0) == '+') {
                this.currentChars = this.currentChars.substring(1);
            }
            this.currentAtomType.setFormalCharge(Integer.parseInt(this.currentChars));
        } else if ("formalNeighbourCount".equals(local)) {
            this.neighborCount = Integer.parseInt(this.currentChars);
        } else if ("lonePairCount".equals(local)) {
            this.currentAtomType.setProperty("cdk:Lone Pair Count", Integer.parseInt(this.currentChars));
        } else if ("singleElectronCount".equals(local)) {
            this.currentAtomType.setProperty("cdk:Single Electron Count", Integer.parseInt(this.currentChars));
        } else if ("piBondCount".equals(local)) {
            this.piBondCount = Integer.parseInt(this.currentChars);
        }
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes atts) {
        this.currentChars = "";
        if ("http://cdk.sf.net/ontologies/atomtypes#".equals(uri)) {
            this.startAtomTypeElement(local, atts);
        }
    }

    private void startAtomTypeElement(String local, Attributes atts) {
        if ("AtomType".equals(local)) {
            this.currentAtomType = builder.newInstance(IAtomType.class, "H");
            this.currentAtomType.setAtomicNumber(null);
            this.currentAtomType.setAtomTypeName(atts.getValue("rdf:ID"));
            this.piBondCount = 0;
            this.neighborCount = 0;
            this.maxBondOrder = IBond.Order.UNSET;
            this.bondOrderSum = 0.0;
        } else if ("hasElement".equals(local)) {
            String attrValue = atts.getValue("rdf:resource");
            this.currentAtomType.setSymbol(attrValue.substring(attrValue.indexOf(35) + 1));
        } else if ("formalBondType".equals(local)) {
            ++this.neighborCount;
            String attrValue = atts.getValue("rdf:resource");
            String bondType = attrValue.substring(attrValue.indexOf(35) + 1);
            if ("single".equals(bondType)) {
                this.maxBondOrder = BondManipulator.getMaximumBondOrder(this.maxBondOrder, IBond.Order.SINGLE);
                this.bondOrderSum += 1.0;
            } else if ("double".equals(bondType)) {
                this.maxBondOrder = BondManipulator.getMaximumBondOrder(this.maxBondOrder, IBond.Order.DOUBLE);
                ++this.piBondCount;
                this.bondOrderSum += 2.0;
            } else if ("triple".equals(bondType)) {
                this.maxBondOrder = BondManipulator.getMaximumBondOrder(this.maxBondOrder, IBond.Order.TRIPLE);
                this.piBondCount += 2;
                this.bondOrderSum += 3.0;
            } else if ("quadruple".equals(bondType)) {
                this.maxBondOrder = BondManipulator.getMaximumBondOrder(this.maxBondOrder, IBond.Order.QUADRUPLE);
                this.piBondCount += 3;
                this.bondOrderSum += 4.0;
            }
        } else if ("hybridization".equals(local)) {
            String attrValue = atts.getValue("rdf:resource");
            String hybridization = attrValue.substring(attrValue.indexOf(35) + 1);
            if ("sp3".equals(hybridization)) {
                this.currentAtomType.setHybridization(IAtomType.Hybridization.SP3);
            } else if ("sp2".equals(hybridization)) {
                this.currentAtomType.setHybridization(IAtomType.Hybridization.SP2);
            } else if ("sp1".equals(hybridization)) {
                this.currentAtomType.setHybridization(IAtomType.Hybridization.SP1);
            } else if ("s".equals(hybridization)) {
                this.currentAtomType.setHybridization(IAtomType.Hybridization.S);
            } else if ("planar".equals(hybridization)) {
                this.currentAtomType.setHybridization(IAtomType.Hybridization.PLANAR3);
            } else if ("sp3d1".equals(hybridization)) {
                this.currentAtomType.setHybridization(IAtomType.Hybridization.SP3D1);
            } else if ("sp3d2".equals(hybridization)) {
                this.currentAtomType.setHybridization(IAtomType.Hybridization.SP3D2);
            } else if ("sp3d3".equals(hybridization)) {
                this.currentAtomType.setHybridization(IAtomType.Hybridization.SP3D3);
            } else if ("sp3d4".equals(hybridization)) {
                this.currentAtomType.setHybridization(IAtomType.Hybridization.SP3D4);
            } else if ("sp3d5".equals(hybridization)) {
                this.currentAtomType.setHybridization(IAtomType.Hybridization.SP3D5);
            }
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        logger.debug("character data");
        this.currentChars = this.currentChars + new String(chars, start, length);
    }
}

