/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.CyclicCarbohydrateRecognition;
import org.openscience.cdk.stereo.DoubleBondStereochemistry;
import org.openscience.cdk.stereo.ExtendedTetrahedral;
import org.openscience.cdk.stereo.FischerRecognition;
import org.openscience.cdk.stereo.Projection;
import org.openscience.cdk.stereo.Stereocenters;
import org.openscience.cdk.stereo.TetrahedralChirality;

public abstract class StereoElementFactory {
    protected final IAtomContainer container;
    protected final int[][] graph;
    protected final GraphUtil.EdgeToBondMap bondMap;
    protected final Set<Projection> projections = EnumSet.noneOf(Projection.class);

    protected StereoElementFactory(IAtomContainer container, int[][] graph, GraphUtil.EdgeToBondMap bondMap) {
        this.container = container;
        this.graph = graph;
        this.bondMap = bondMap;
    }

    public List<IStereoElement> createAll() {
        Stereocenters centers = new Stereocenters(this.container, this.graph, this.bondMap);
        ArrayList<IStereoElement> elements = new ArrayList<IStereoElement>();
        FischerRecognition fischerRecon = new FischerRecognition(this.container, this.graph, this.bondMap, centers);
        CyclicCarbohydrateRecognition cycleRecon = new CyclicCarbohydrateRecognition(this.container, this.graph, this.bondMap, centers);
        elements.addAll(fischerRecon.recognise(this.projections));
        elements.addAll(cycleRecon.recognise(this.projections));
        block5: for (int v = 0; v < this.graph.length; ++v) {
            switch (centers.elementType(v)) {
                case Bicoordinate: {
                    Object element;
                    int t0 = this.graph[v][0];
                    int t1 = this.graph[v][1];
                    if (centers.elementType(t0) != Stereocenters.Type.Tricoordinate || centers.elementType(t1) != Stereocenters.Type.Tricoordinate || !centers.isStereocenter(t0) || !centers.isStereocenter(t1) || (element = this.createExtendedTetrahedral(v, centers)) == null) continue block5;
                    elements.add((IStereoElement)element);
                    continue block5;
                }
                case Tricoordinate: {
                    if (!centers.isStereocenter(v)) continue block5;
                    Object element = this.graph[v];
                    int n = ((Object)element).length;
                    for (int i = 0; i < n; ++i) {
                        IDoubleBondStereochemistry element2;
                        Object w = element[i];
                        if (w <= v || this.bondMap.get(v, (int)w).getOrder() != IBond.Order.DOUBLE) continue;
                        if (!centers.isStereocenter((int)w) || (element2 = this.createGeometric(v, (int)w, centers)) == null) continue block5;
                        elements.add(element2);
                        continue block5;
                    }
                    continue block5;
                }
                case Tetracoordinate: {
                    Object element = this.createTetrahedral(v, centers);
                    if (element == null) continue block5;
                    elements.add((IStereoElement)element);
                }
            }
        }
        return elements;
    }

    abstract ITetrahedralChirality createTetrahedral(int var1, Stereocenters var2);

    abstract ITetrahedralChirality createTetrahedral(IAtom var1, Stereocenters var2);

    abstract IDoubleBondStereochemistry createGeometric(int var1, int var2, Stereocenters var3);

    abstract IDoubleBondStereochemistry createGeometric(IBond var1, Stereocenters var2);

    abstract ExtendedTetrahedral createExtendedTetrahedral(int var1, Stereocenters var2);

    public StereoElementFactory interpretProjections(Projection ... projections) {
        Collections.addAll(this.projections, projections);
        return this;
    }

    public static StereoElementFactory using2DCoordinates(IAtomContainer container) {
        GraphUtil.EdgeToBondMap bondMap = GraphUtil.EdgeToBondMap.withSpaceFor(container);
        int[][] graph = GraphUtil.toAdjList(container, bondMap);
        return new StereoElementFactory2D(container, graph, bondMap);
    }

    public static StereoElementFactory using3DCoordinates(IAtomContainer container) {
        GraphUtil.EdgeToBondMap bondMap = GraphUtil.EdgeToBondMap.withSpaceFor(container);
        int[][] graph = GraphUtil.toAdjList(container, bondMap);
        return new StereoElementFactory3D(container, graph, bondMap);
    }

    private static boolean hasUnspecifiedParity(IAtom atom) {
        return atom.getStereoParity() != null && atom.getStereoParity() == 3;
    }

    private static final class StereoElementFactory3D
    extends StereoElementFactory {
        StereoElementFactory3D(IAtomContainer container, int[][] graph, GraphUtil.EdgeToBondMap bondMap) {
            super(container, graph, bondMap);
        }

        @Override
        ITetrahedralChirality createTetrahedral(IAtom atom, Stereocenters stereocenters) {
            return this.createTetrahedral(this.container.indexOf(atom), stereocenters);
        }

        @Override
        IDoubleBondStereochemistry createGeometric(IBond bond, Stereocenters stereocenters) {
            return this.createGeometric(this.container.indexOf(bond.getBegin()), this.container.indexOf(bond.getEnd()), stereocenters);
        }

        @Override
        ITetrahedralChirality createTetrahedral(int v, Stereocenters stereocenters) {
            if (!stereocenters.isStereocenter(v)) {
                return null;
            }
            IAtom focus = this.container.getAtom(v);
            if (StereoElementFactory.hasUnspecifiedParity(focus)) {
                return null;
            }
            IAtom[] neighbors = new IAtom[4];
            neighbors[3] = focus;
            int n = 0;
            for (int w : this.graph[v]) {
                neighbors[n++] = this.container.getAtom(w);
            }
            if (n < 3 || n > 4) {
                return null;
            }
            int parity = this.parity(neighbors);
            ITetrahedralChirality.Stereo winding = parity > 0 ? ITetrahedralChirality.Stereo.ANTI_CLOCKWISE : ITetrahedralChirality.Stereo.CLOCKWISE;
            return new TetrahedralChirality(focus, neighbors, winding);
        }

        @Override
        IDoubleBondStereochemistry createGeometric(int u, int v, Stereocenters stereocenters) {
            if (StereoElementFactory.hasUnspecifiedParity(this.container.getAtom(u)) || StereoElementFactory.hasUnspecifiedParity(this.container.getAtom(v))) {
                return null;
            }
            int[] us = this.graph[u];
            int[] vs = this.graph[v];
            int x = us[0] == v ? us[1] : us[0];
            int w = vs[0] == u ? vs[1] : vs[0];
            IAtom uAtom = this.container.getAtom(u);
            IAtom vAtom = this.container.getAtom(v);
            IAtom uSubstituentAtom = this.container.getAtom(x);
            IAtom vSubstituentAtom = this.container.getAtom(w);
            if (uAtom.getPoint3d() == null || vAtom.getPoint3d() == null || uSubstituentAtom.getPoint3d() == null || vSubstituentAtom.getPoint3d() == null) {
                return null;
            }
            int parity = this.parity(uAtom.getPoint3d(), vAtom.getPoint3d(), uSubstituentAtom.getPoint3d(), vSubstituentAtom.getPoint3d());
            IDoubleBondStereochemistry.Conformation conformation = parity > 0 ? IDoubleBondStereochemistry.Conformation.OPPOSITE : IDoubleBondStereochemistry.Conformation.TOGETHER;
            IBond bond = this.bondMap.get(u, v);
            bond.setAtoms(new IAtom[]{uAtom, vAtom});
            return new DoubleBondStereochemistry(bond, new IBond[]{this.bondMap.get(u, x), this.bondMap.get(v, w)}, conformation);
        }

        @Override
        ExtendedTetrahedral createExtendedTetrahedral(int v, Stereocenters stereocenters) {
            IAtom focus = this.container.getAtom(v);
            if (StereoElementFactory.hasUnspecifiedParity(focus)) {
                return null;
            }
            IAtom[] terminals = ExtendedTetrahedral.findTerminalAtoms(this.container, focus);
            IAtom[] neighbors = new IAtom[4];
            int t0 = this.container.indexOf(terminals[0]);
            int t1 = this.container.indexOf(terminals[1]);
            if (this.bondMap.get(v, t0).getOrder() != IBond.Order.DOUBLE || this.bondMap.get(v, t1).getOrder() != IBond.Order.DOUBLE) {
                return null;
            }
            neighbors[1] = terminals[0];
            neighbors[3] = terminals[1];
            int n = 0;
            for (int w : this.graph[t0]) {
                if (this.bondMap.get(t0, w).getOrder() != IBond.Order.SINGLE) continue;
                neighbors[n++] = this.container.getAtom(w);
            }
            n = 2;
            for (int w : this.graph[t1]) {
                if (this.bondMap.get(t1, w).getOrder() != IBond.Order.SINGLE) continue;
                neighbors[n++] = this.container.getAtom(w);
            }
            int parity = this.parity(neighbors);
            ITetrahedralChirality.Stereo winding = parity > 0 ? ITetrahedralChirality.Stereo.ANTI_CLOCKWISE : ITetrahedralChirality.Stereo.CLOCKWISE;
            return new ExtendedTetrahedral(focus, neighbors, winding);
        }

        private static double det(double xa, double ya, double xb, double yb, double xc, double yc) {
            return (xa - xc) * (yb - yc) - (ya - yc) * (xb - xc);
        }

        private int parity(Point3d u, Point3d v, Point3d x, Point3d w) {
            double[] vu = StereoElementFactory3D.toVector(v, u);
            double[] vw = StereoElementFactory3D.toVector(v, w);
            double[] ux = StereoElementFactory3D.toVector(u, x);
            double[] normal = StereoElementFactory3D.crossProduct(vu, StereoElementFactory3D.crossProduct(vu, vw));
            int parity = (int)Math.signum(StereoElementFactory3D.dot(normal, vw)) * (int)Math.signum(StereoElementFactory3D.dot(normal, ux));
            return parity * -1;
        }

        private int parity(IAtom[] atoms) {
            if (atoms.length != 4) {
                throw new IllegalArgumentException("incorrect number of atoms");
            }
            Point3d[] coordinates = new Point3d[atoms.length];
            for (int i = 0; i < atoms.length; ++i) {
                coordinates[i] = atoms[i].getPoint3d();
                if (coordinates[i] != null) continue;
                return 0;
            }
            double x1 = coordinates[0].x;
            double x2 = coordinates[1].x;
            double x3 = coordinates[2].x;
            double x4 = coordinates[3].x;
            double y1 = coordinates[0].y;
            double y2 = coordinates[1].y;
            double y3 = coordinates[2].y;
            double y4 = coordinates[3].y;
            double z1 = coordinates[0].z;
            double z2 = coordinates[1].z;
            double z3 = coordinates[2].z;
            double z4 = coordinates[3].z;
            double det = z1 * StereoElementFactory3D.det(x2, y2, x3, y3, x4, y4) - z2 * StereoElementFactory3D.det(x1, y1, x3, y3, x4, y4) + z3 * StereoElementFactory3D.det(x1, y1, x2, y2, x4, y4) - z4 * StereoElementFactory3D.det(x1, y1, x2, y2, x3, y3);
            return (int)Math.signum(det);
        }

        private static double[] toVector(Point3d src, Point3d dest) {
            return new double[]{dest.x - src.x, dest.y - src.y, dest.z - src.z};
        }

        private static double dot(double[] u, double[] v) {
            return u[0] * v[0] + u[1] * v[1] + u[2] * v[2];
        }

        private static double[] crossProduct(double[] u, double[] v) {
            return new double[]{u[1] * v[2] - v[1] * u[2], u[2] * v[0] - v[2] * u[0], u[0] * v[1] - v[0] * u[1]};
        }
    }

    static final class StereoElementFactory2D
    extends StereoElementFactory {
        private static final double THRESHOLD = 0.1;

        StereoElementFactory2D(IAtomContainer container, int[][] graph, GraphUtil.EdgeToBondMap bondMap) {
            super(container, graph, bondMap);
        }

        @Override
        ITetrahedralChirality createTetrahedral(IAtom atom, Stereocenters stereocenters) {
            return this.createTetrahedral(this.container.indexOf(atom), stereocenters);
        }

        @Override
        IDoubleBondStereochemistry createGeometric(IBond bond, Stereocenters stereocenters) {
            return this.createGeometric(this.container.indexOf(bond.getBegin()), this.container.indexOf(bond.getEnd()), stereocenters);
        }

        @Override
        ITetrahedralChirality createTetrahedral(int v, Stereocenters stereocenters) {
            int parity;
            IAtom focus = this.container.getAtom(v);
            if (StereoElementFactory.hasUnspecifiedParity(focus)) {
                return null;
            }
            IAtom[] neighbors = new IAtom[4];
            int[] elevation = new int[4];
            neighbors[3] = focus;
            boolean nonplanar = false;
            int n = 0;
            for (int w : this.graph[v]) {
                IBond bond = this.bondMap.get(v, w);
                if (this.isUnspecified(bond)) {
                    return null;
                }
                neighbors[n] = this.container.getAtom(w);
                elevation[n] = this.elevationOf(focus, bond);
                if (elevation[n] != 0) {
                    nonplanar = true;
                }
                ++n;
            }
            if (n < 3 || n > 4) {
                return null;
            }
            if (!nonplanar) {
                int[] ws = this.graph[v];
                for (int i = 0; i < ws.length; ++i) {
                    int w = ws[i];
                    IBond bond = this.bondMap.get(v, w);
                    if (bond.getStereo() != IBond.Stereo.DOWN && bond.getStereo() != IBond.Stereo.DOWN_INVERTED || stereocenters.isStereocenter(w)) continue;
                    elevation[i] = -1;
                    nonplanar = true;
                }
                if (!nonplanar) {
                    return null;
                }
            }
            if ((parity = this.parity(focus, neighbors, elevation)) == 0) {
                return null;
            }
            ITetrahedralChirality.Stereo winding = parity > 0 ? ITetrahedralChirality.Stereo.ANTI_CLOCKWISE : ITetrahedralChirality.Stereo.CLOCKWISE;
            return new TetrahedralChirality(focus, neighbors, winding);
        }

        @Override
        IDoubleBondStereochemistry createGeometric(int u, int v, Stereocenters stereocenters) {
            IDoubleBondStereochemistry.Conformation conformation;
            if (StereoElementFactory.hasUnspecifiedParity(this.container.getAtom(u)) || StereoElementFactory.hasUnspecifiedParity(this.container.getAtom(v))) {
                return null;
            }
            int[] us = this.graph[u];
            int[] vs = this.graph[v];
            if (us.length < 2 || us.length > 3 || vs.length < 2 || vs.length > 3) {
                return null;
            }
            StereoElementFactory2D.moveToBack(us, v);
            StereoElementFactory2D.moveToBack(vs, u);
            IAtom[] vAtoms = new IAtom[]{this.container.getAtom(us[0]), this.container.getAtom(us.length > 2 ? us[1] : u), this.container.getAtom(v)};
            IAtom[] wAtoms = new IAtom[]{this.container.getAtom(vs[0]), this.container.getAtom(vs.length > 2 ? vs[1] : v), this.container.getAtom(u)};
            if (this.isUnspecified(this.bondMap.get(u, us[0])) || this.isUnspecified(this.bondMap.get(u, us[1])) || this.isUnspecified(this.bondMap.get(v, vs[0])) || this.isUnspecified(this.bondMap.get(v, vs[1]))) {
                return null;
            }
            int parity = this.parity(vAtoms) * this.parity(wAtoms);
            IDoubleBondStereochemistry.Conformation conformation2 = conformation = parity > 0 ? IDoubleBondStereochemistry.Conformation.OPPOSITE : IDoubleBondStereochemistry.Conformation.TOGETHER;
            if (parity == 0) {
                return null;
            }
            IBond bond = this.bondMap.get(u, v);
            if (this.isUnspecified(bond)) {
                return null;
            }
            bond.setAtoms(new IAtom[]{this.container.getAtom(u), this.container.getAtom(v)});
            return new DoubleBondStereochemistry(bond, new IBond[]{this.bondMap.get(u, us[0]), this.bondMap.get(v, vs[0])}, conformation);
        }

        @Override
        ExtendedTetrahedral createExtendedTetrahedral(int v, Stereocenters stereocenters) {
            IBond bond;
            IAtom focus = this.container.getAtom(v);
            if (StereoElementFactory.hasUnspecifiedParity(focus)) {
                return null;
            }
            IAtom[] terminals = ExtendedTetrahedral.findTerminalAtoms(this.container, focus);
            int t0 = this.container.indexOf(terminals[0]);
            int t1 = this.container.indexOf(terminals[1]);
            if (this.bondMap.get(v, t0).getOrder() != IBond.Order.DOUBLE || this.bondMap.get(v, t1).getOrder() != IBond.Order.DOUBLE) {
                return null;
            }
            IAtom[] neighbors = new IAtom[4];
            int[] elevation = new int[4];
            neighbors[1] = terminals[0];
            neighbors[3] = terminals[1];
            int n = 0;
            for (int w : this.graph[t0]) {
                bond = this.bondMap.get(t0, w);
                if (w == v) continue;
                if (bond.getOrder() != IBond.Order.SINGLE) {
                    return null;
                }
                if (this.isUnspecified(bond)) {
                    return null;
                }
                neighbors[n] = this.container.getAtom(w);
                elevation[n] = this.elevationOf(terminals[0], bond);
                ++n;
            }
            n = 2;
            for (int w : this.graph[t1]) {
                bond = this.bondMap.get(t1, w);
                if (w == v) continue;
                if (bond.getOrder() != IBond.Order.SINGLE) {
                    return null;
                }
                if (this.isUnspecified(bond)) {
                    return null;
                }
                neighbors[n] = this.container.getAtom(w);
                elevation[n] = this.elevationOf(terminals[1], bond);
                ++n;
            }
            if (elevation[0] != 0 || elevation[1] != 0 ? elevation[2] != 0 || elevation[3] != 0 : elevation[2] == 0 && elevation[3] == 0) {
                return null;
            }
            int parity = this.parity(focus, neighbors, elevation);
            ITetrahedralChirality.Stereo winding = parity > 0 ? ITetrahedralChirality.Stereo.ANTI_CLOCKWISE : ITetrahedralChirality.Stereo.CLOCKWISE;
            return new ExtendedTetrahedral(focus, neighbors, winding);
        }

        private boolean isUnspecified(IBond bond) {
            switch (bond.getStereo()) {
                case UP_OR_DOWN: 
                case UP_OR_DOWN_INVERTED: 
                case E_OR_Z: {
                    return true;
                }
            }
            return false;
        }

        private int parity(IAtom[] atoms) {
            if (atoms.length != 3) {
                throw new IllegalArgumentException("incorrect number of atoms");
            }
            Point2d a = atoms[0].getPoint2d();
            Point2d b = atoms[1].getPoint2d();
            Point2d c = atoms[2].getPoint2d();
            if (a == null || b == null || c == null) {
                return 0;
            }
            double det = StereoElementFactory2D.det(a.x, a.y, b.x, b.y, c.x, c.y);
            if (Math.abs(det) < 0.1) {
                return 0;
            }
            return (int)Math.signum(det);
        }

        private int parity(IAtom focus, IAtom[] atoms, int[] elevations) {
            if (atoms.length != 4) {
                throw new IllegalArgumentException("incorrect number of atoms");
            }
            Point2d[] coordinates = new Point2d[atoms.length];
            for (int i = 0; i < atoms.length; ++i) {
                coordinates[i] = atoms[i].getPoint2d();
                if (coordinates[i] == null) {
                    return 0;
                }
                coordinates[i] = this.toUnitVector(focus.getPoint2d(), atoms[i].getPoint2d());
            }
            double det = this.parity(coordinates, elevations);
            return (int)Math.signum(det);
        }

        private Point2d toUnitVector(Point2d from, Point2d to) {
            if (from == to) {
                return new Point2d(0.0, 0.0);
            }
            Vector2d v2d = new Vector2d(to.x - from.x, to.y - from.y);
            v2d.normalize();
            return new Point2d(v2d);
        }

        private double parity(Point2d[] coordinates, int[] elevations) {
            double x1 = coordinates[0].x;
            double x2 = coordinates[1].x;
            double x3 = coordinates[2].x;
            double x4 = coordinates[3].x;
            double y1 = coordinates[0].y;
            double y2 = coordinates[1].y;
            double y3 = coordinates[2].y;
            double y4 = coordinates[3].y;
            return (double)elevations[0] * StereoElementFactory2D.det(x2, y2, x3, y3, x4, y4) - (double)elevations[1] * StereoElementFactory2D.det(x1, y1, x3, y3, x4, y4) + (double)elevations[2] * StereoElementFactory2D.det(x1, y1, x2, y2, x4, y4) - (double)elevations[3] * StereoElementFactory2D.det(x1, y1, x2, y2, x3, y3);
        }

        private static double det(double xa, double ya, double xb, double yb, double xc, double yc) {
            return (xa - xc) * (yb - yc) - (ya - yc) * (xb - xc);
        }

        private static void moveToBack(int[] vs, int v) {
            for (int i = 0; i < vs.length; ++i) {
                if (vs[i] != v) continue;
                System.arraycopy(vs, i + 1, vs, i + 1 - 1, vs.length - (i + 1));
                vs[vs.length - 1] = v;
                return;
            }
        }

        private int elevationOf(IAtom focus, IBond bond) {
            switch (bond.getStereo()) {
                case UP: {
                    return bond.getBegin().equals(focus) ? 1 : 0;
                }
                case UP_INVERTED: {
                    return bond.getEnd().equals(focus) ? 1 : 0;
                }
                case DOWN: {
                    return bond.getBegin().equals(focus) ? -1 : 0;
                }
                case DOWN_INVERTED: {
                    return bond.getEnd().equals(focus) ? -1 : 0;
                }
            }
            return 0;
        }
    }
}

