/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BiconnectedComponents {
    private boolean[] visited;
    private int[] d;
    private int[] low;
    private final Graph g;
    private final Deque<Edge> stack;
    private final List<List<Edge>> components = new ArrayList<List<Edge>>(2);
    int count = 0;

    BiconnectedComponents(Graph g) {
        this.visited = new boolean[g.order()];
        this.d = new int[g.order()];
        this.low = new int[g.order()];
        this.g = g;
        this.stack = new ArrayDeque<Edge>();
        for (int u = 0; u < g.order(); ++u) {
            if (this.visited[u]) continue;
            this.visit(u, u);
        }
        this.low = null;
        this.d = null;
    }

    private void visit(int u, int p) {
        this.visited[u] = true;
        this.d[u] = ++this.count;
        this.low[u] = this.count;
        for (Edge e : this.g.edges(u)) {
            int v = e.other(u);
            if (!this.visited[v]) {
                this.stack.push(e);
                this.visit(v, u);
                if (this.low[v] >= this.d[u]) {
                    this.store(e);
                }
                this.low[u] = Math.min(this.low[u], this.low[v]);
                continue;
            }
            if (v == p || this.d[v] >= this.d[u]) continue;
            this.stack.push(e);
            this.low[u] = Math.min(this.low[u], this.d[v]);
        }
    }

    private void store(Edge e) {
        ArrayList<Edge> component = new ArrayList<Edge>();
        while (!this.stack.peek().equals(e)) {
            component.add(this.stack.pop());
        }
        component.add(this.stack.pop());
        if (component.size() > 1) {
            this.components.add(Collections.unmodifiableList(component));
        }
    }

    public List<List<Edge>> components() {
        return Collections.unmodifiableList(this.components);
    }

    BitSet cyclic() {
        BitSet cyclic = new BitSet(this.g.order());
        for (List<Edge> component : this.components) {
            for (Edge e : component) {
                int u = e.either();
                int v = e.other(u);
                cyclic.set(u);
                cyclic.set(v);
            }
        }
        return cyclic;
    }
}

