/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.rebond;

import java.util.Iterator;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.rebond.Bspt;
import org.openscience.cdk.graph.rebond.Point;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

@TestClass(value="org.openscience.cdk.graph.rebond.RebondToolTest")
public class RebondTool {
    private double maxCovalentRadius;
    private double minBondDistance;
    private double bondTolerance;
    private Bspt bspt;

    public RebondTool(double maxCovalentRadius, double minBondDistance, double bondTolerance) {
        this.maxCovalentRadius = maxCovalentRadius;
        this.bondTolerance = bondTolerance;
        this.minBondDistance = minBondDistance;
        this.bspt = null;
    }

    @TestMethod(value="testRebond_IAtomContainer")
    public void rebond(IAtomContainer container) throws CDKException {
        container.removeAllBonds();
        this.maxCovalentRadius = 0.0;
        this.bspt = new Bspt(3);
        for (IAtom atom : container.atoms()) {
            double myCovalentRadius = atom.getCovalentRadius();
            if (myCovalentRadius == 0.0) {
                throw new CDKException("Atom(s) does not have covalentRadius defined.");
            }
            if (myCovalentRadius > this.maxCovalentRadius) {
                this.maxCovalentRadius = myCovalentRadius;
            }
            TupleAtom tupleAtom = new TupleAtom(atom);
            this.bspt.addTuple(tupleAtom);
        }
        Iterator atoms = container.atoms().iterator();
        while (atoms.hasNext()) {
            this.bondAtom(container, (IAtom)atoms.next());
        }
    }

    private void bondAtom(IAtomContainer container, IAtom atom) {
        double myCovalentRadius = atom.getCovalentRadius();
        double searchRadius = myCovalentRadius + this.maxCovalentRadius + this.bondTolerance;
        Point tupleAtom = new Point(atom.getPoint3d().x, atom.getPoint3d().y, atom.getPoint3d().z);
        Bspt.EnumerateSphere e = this.bspt.enumHemiSphere(tupleAtom, searchRadius);
        while (e.hasMoreElements()) {
            boolean bonded;
            IAtom atomNear = ((TupleAtom)e.nextElement()).getAtom();
            if (atomNear == atom || container.getBond(atom, atomNear) != null || !(bonded = this.isBonded(myCovalentRadius, atomNear.getCovalentRadius(), e.foundDistance2()))) continue;
            IBond bond = (IBond)atom.getBuilder().newInstance(IBond.class, new Object[]{atom, atomNear, IBond.Order.SINGLE});
            container.addBond(bond);
        }
    }

    private boolean isBonded(double covalentRadiusA, double covalentRadiusB, double distance2) {
        double maxAcceptable = covalentRadiusA + covalentRadiusB + this.bondTolerance;
        double maxAcceptable2 = maxAcceptable * maxAcceptable;
        double minBondDistance2 = this.minBondDistance * this.minBondDistance;
        if (distance2 < minBondDistance2) {
            return false;
        }
        return distance2 <= maxAcceptable2;
    }

    class TupleAtom
    implements Bspt.Tuple {
        IAtom atom;

        TupleAtom(IAtom atom) {
            this.atom = atom;
        }

        @Override
        public double getDimValue(int dim) {
            if (dim == 0) {
                return this.atom.getPoint3d().x;
            }
            if (dim == 1) {
                return this.atom.getPoint3d().y;
            }
            return this.atom.getPoint3d().z;
        }

        public IAtom getAtom() {
            return this.atom;
        }

        public String toString() {
            return "<" + this.atom.getPoint3d().x + "," + this.atom.getPoint3d().y + "," + this.atom.getPoint3d().z + ">";
        }
    }
}

