/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.elements.TextElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.ReactionSceneGenerator;

@TestClass(value="org.openscience.cdk.renderer.generators.ReactionBoxGeneratorTest")
public class ReactionBoxGenerator
implements IGenerator<IReaction> {
    @TestMethod(value="testEmptyReaction")
    public IRenderingElement generate(IReaction reaction, RendererModel model) {
        if (!((Boolean)((ReactionSceneGenerator.ShowReactionBoxes)model.getParameter(ReactionSceneGenerator.ShowReactionBoxes.class)).getValue()).booleanValue()) {
            return null;
        }
        double separation = (Double)((BasicSceneGenerator.BondLength)model.getParameter(BasicSceneGenerator.BondLength.class)).getValue() / (Double)((BasicSceneGenerator.Scale)model.getParameter(BasicSceneGenerator.Scale.class)).getValue();
        Rectangle2D totalBounds = BoundsCalculator.calculateBounds((IReaction)reaction);
        if (totalBounds == null) {
            return null;
        }
        ElementGroup diagram = new ElementGroup();
        Color foregroundColor = (Color)((BasicSceneGenerator.ForegroundColor)model.getParameter(BasicSceneGenerator.ForegroundColor.class)).getValue();
        diagram.add((IRenderingElement)new RectangleElement(totalBounds.getMinX() - separation, totalBounds.getMinY() - separation, totalBounds.getMaxX() + separation, totalBounds.getMaxY() + separation, foregroundColor));
        if (reaction.getID() != null) {
            diagram.add((IRenderingElement)new TextElement((totalBounds.getMinX() + totalBounds.getMaxX()) / 2.0, totalBounds.getMinY() - separation, reaction.getID(), foregroundColor));
        }
        return diagram;
    }

    @TestMethod(value="testGetParameters")
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(new IGeneratorParameter[0]);
    }
}

