/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

@TestClass(value="org.openscience.cdk.silent.MolecularFormulaSetTest")
public class MolecularFormulaSet
implements Iterable<IMolecularFormula>,
IMolecularFormulaSet,
Cloneable {
    private static final long serialVersionUID = -2043178712150212550L;
    private List<IMolecularFormula> components = new ArrayList<IMolecularFormula>();

    public MolecularFormulaSet() {
    }

    public MolecularFormulaSet(IMolecularFormula formula) {
        this.components.add(0, formula);
    }

    @Override
    @TestMethod(value="testAdd_IMolecularFormulaSet")
    public void add(IMolecularFormulaSet formulaSet) {
        for (IMolecularFormula mf : formulaSet.molecularFormulas()) {
            this.addMolecularFormula(mf);
        }
    }

    @Override
    @TestMethod(value="testAdd_IMolecularFormula")
    public void addMolecularFormula(IMolecularFormula formula) {
        this.components.add(formula);
    }

    @Override
    @TestMethod(value="testMolecularFormulas")
    public Iterable<IMolecularFormula> molecularFormulas() {
        return this.components;
    }

    @Override
    @TestMethod(value="testIterator")
    public Iterator<IMolecularFormula> iterator() {
        return this.components.iterator();
    }

    @Override
    @TestMethod(value="testSize")
    public int size() {
        return this.components.size();
    }

    @Override
    @TestMethod(value="testContains_IMolecularFormula")
    public boolean contains(IMolecularFormula formula) {
        return this.components.contains(formula);
    }

    @Override
    @TestMethod(value="testGetMolecularFormula_int")
    public IMolecularFormula getMolecularFormula(int position) {
        return this.components.get(position);
    }

    @Override
    @TestMethod(value="testRemoveAllMolecularFormulas")
    public void removeAllMolecularFormulas() {
        this.components.clear();
    }

    @Override
    @TestMethod(value="testRemoveMolecularFormula_IMolecularFormula")
    public void removeMolecularFormula(IMolecularFormula formula) {
        this.components.remove(formula);
    }

    @Override
    @TestMethod(value="testRemoveMolecularFormula_int")
    public void removeMolecularFormula(int position) {
        this.components.remove(position);
    }

    @Override
    @TestMethod(value="testClone")
    public Object clone() throws CloneNotSupportedException {
        MolecularFormulaSet clone = new MolecularFormulaSet();
        for (IMolecularFormula mf : this.molecularFormulas()) {
            clone.addMolecularFormula((IMolecularFormula)mf.clone());
        }
        return clone;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return SilentChemObjectBuilder.getInstance();
    }
}

