/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.silent.ChemObject;
import org.openscience.cdk.silent.SingleElectron;

public class AtomContainer
extends ChemObject
implements IAtomContainer,
IChemObjectListener,
Serializable,
Cloneable {
    private static final long serialVersionUID = 5678100348445919254L;
    protected int atomCount;
    protected int bondCount;
    protected int lonePairCount;
    protected int singleElectronCount;
    protected int growArraySize = 10;
    protected IAtom[] atoms;
    protected IBond[] bonds;
    protected ILonePair[] lonePairs;
    protected ISingleElectron[] singleElectrons;
    protected Set<IStereoElement> stereoElements;

    public AtomContainer() {
        this(10, 10, 0, 0);
    }

    public AtomContainer(IAtomContainer container) {
        int f;
        this.atomCount = container.getAtomCount();
        this.bondCount = container.getBondCount();
        this.lonePairCount = container.getLonePairCount();
        this.singleElectronCount = container.getSingleElectronCount();
        this.atoms = new IAtom[this.atomCount];
        this.bonds = new IBond[this.bondCount];
        this.lonePairs = new ILonePair[this.lonePairCount];
        this.singleElectrons = new ISingleElectron[this.singleElectronCount];
        this.stereoElements = new HashSet<IStereoElement>(this.atomCount / 2);
        for (IStereoElement element : container.stereoElements()) {
            this.addStereoElement(element);
        }
        for (f = 0; f < container.getAtomCount(); ++f) {
            this.atoms[f] = container.getAtom(f);
        }
        for (f = 0; f < this.bondCount; ++f) {
            this.bonds[f] = container.getBond(f);
        }
        for (f = 0; f < this.lonePairCount; ++f) {
            this.lonePairs[f] = container.getLonePair(f);
        }
        for (f = 0; f < this.singleElectronCount; ++f) {
            this.singleElectrons[f] = container.getSingleElectron(f);
        }
    }

    public AtomContainer(int atomCount, int bondCount, int lpCount, int seCount) {
        this.atomCount = 0;
        this.bondCount = 0;
        this.lonePairCount = 0;
        this.singleElectronCount = 0;
        this.atoms = new IAtom[atomCount];
        this.bonds = new IBond[bondCount];
        this.lonePairs = new ILonePair[lpCount];
        this.singleElectrons = new ISingleElectron[seCount];
        this.stereoElements = new HashSet<IStereoElement>(atomCount / 2);
    }

    @Override
    public void addStereoElement(IStereoElement element) {
        this.stereoElements.add(element);
    }

    @Override
    public void setStereoElements(List<IStereoElement> elements) {
        this.stereoElements = new HashSet<IStereoElement>();
        this.stereoElements.addAll(elements);
    }

    @Override
    public Iterable<IStereoElement> stereoElements() {
        return Collections.unmodifiableSet(this.stereoElements);
    }

    @Override
    public void setAtoms(IAtom[] atoms) {
        this.atoms = atoms;
        this.atomCount = atoms.length;
    }

    @Override
    public void setBonds(IBond[] bonds) {
        this.bonds = bonds;
        this.bondCount = bonds.length;
    }

    @Override
    public void setAtom(int number, IAtom atom) {
        this.atoms[number] = atom;
    }

    @Override
    public IAtom getAtom(int number) {
        return this.atoms[number];
    }

    @Override
    public IBond getBond(int number) {
        return this.bonds[number];
    }

    @Override
    public ILonePair getLonePair(int number) {
        return this.lonePairs[number];
    }

    @Override
    public ISingleElectron getSingleElectron(int number) {
        return this.singleElectrons[number];
    }

    @Override
    public Iterable<IAtom> atoms() {
        return new Iterable<IAtom>(){

            @Override
            public Iterator<IAtom> iterator() {
                return new AtomIterator();
            }
        };
    }

    @Override
    public Iterable<IBond> bonds() {
        return new Iterable<IBond>(){

            @Override
            public Iterator<IBond> iterator() {
                return new BondIterator();
            }
        };
    }

    @Override
    public Iterable<ILonePair> lonePairs() {
        return new Iterable<ILonePair>(){

            @Override
            public Iterator<ILonePair> iterator() {
                return new LonePairIterator();
            }
        };
    }

    @Override
    public Iterable<ISingleElectron> singleElectrons() {
        return new Iterable<ISingleElectron>(){

            @Override
            public Iterator<ISingleElectron> iterator() {
                return new SingleElectronIterator();
            }
        };
    }

    @Override
    public Iterable<IElectronContainer> electronContainers() {
        return new Iterable<IElectronContainer>(){

            @Override
            public Iterator<IElectronContainer> iterator() {
                return new ElectronContainerIterator();
            }
        };
    }

    @Override
    public IAtom getFirstAtom() {
        return this.atoms[0];
    }

    @Override
    public IAtom getLastAtom() {
        return this.getAtomCount() > 0 ? this.atoms[this.getAtomCount() - 1] : null;
    }

    @Override
    public int getAtomNumber(IAtom atom) {
        for (int f = 0; f < this.atomCount; ++f) {
            if (this.atoms[f] != atom) continue;
            return f;
        }
        return -1;
    }

    @Override
    public int getBondNumber(IAtom atom1, IAtom atom2) {
        return this.getBondNumber(this.getBond(atom1, atom2));
    }

    @Override
    public int getBondNumber(IBond bond) {
        for (int f = 0; f < this.bondCount; ++f) {
            if (this.bonds[f] != bond) continue;
            return f;
        }
        return -1;
    }

    @Override
    public int getLonePairNumber(ILonePair lonePair) {
        for (int f = 0; f < this.lonePairCount; ++f) {
            if (this.lonePairs[f] != lonePair) continue;
            return f;
        }
        return -1;
    }

    @Override
    public int getSingleElectronNumber(ISingleElectron singleElectron) {
        for (int f = 0; f < this.singleElectronCount; ++f) {
            if (this.singleElectrons[f] != singleElectron) continue;
            return f;
        }
        return -1;
    }

    @Override
    public IElectronContainer getElectronContainer(int number) {
        if (number < this.bondCount) {
            return this.bonds[number];
        }
        if ((number -= this.bondCount) < this.lonePairCount) {
            return this.lonePairs[number];
        }
        if ((number -= this.lonePairCount) < this.singleElectronCount) {
            return this.singleElectrons[number];
        }
        return null;
    }

    @Override
    public IBond getBond(IAtom atom1, IAtom atom2) {
        for (int i = 0; i < this.getBondCount(); ++i) {
            if (!this.bonds[i].contains(atom1) || this.bonds[i].getConnectedAtom(atom1) != atom2) continue;
            return this.bonds[i];
        }
        return null;
    }

    @Override
    public int getAtomCount() {
        return this.atomCount;
    }

    @Override
    public int getBondCount() {
        return this.bondCount;
    }

    @Override
    public int getLonePairCount() {
        return this.lonePairCount;
    }

    @Override
    public int getSingleElectronCount() {
        return this.singleElectronCount;
    }

    @Override
    public int getElectronContainerCount() {
        return this.bondCount + this.lonePairCount + this.singleElectronCount;
    }

    @Override
    public List<IAtom> getConnectedAtomsList(IAtom atom) {
        ArrayList<IAtom> atomsList = new ArrayList<IAtom>();
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom)) continue;
            atomsList.add(this.bonds[i].getConnectedAtom(atom));
        }
        return atomsList;
    }

    @Override
    public List<IBond> getConnectedBondsList(IAtom atom) {
        ArrayList<IBond> bondsList = new ArrayList<IBond>();
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom)) continue;
            bondsList.add(this.bonds[i]);
        }
        return bondsList;
    }

    @Override
    public List<ILonePair> getConnectedLonePairsList(IAtom atom) {
        ArrayList<ILonePair> lps = new ArrayList<ILonePair>();
        for (int i = 0; i < this.lonePairCount; ++i) {
            if (!this.lonePairs[i].contains(atom)) continue;
            lps.add(this.lonePairs[i]);
        }
        return lps;
    }

    @Override
    public List<ISingleElectron> getConnectedSingleElectronsList(IAtom atom) {
        ArrayList<ISingleElectron> lps = new ArrayList<ISingleElectron>();
        for (int i = 0; i < this.singleElectronCount; ++i) {
            if (!this.singleElectrons[i].contains(atom)) continue;
            lps.add(this.singleElectrons[i]);
        }
        return lps;
    }

    @Override
    public List<IElectronContainer> getConnectedElectronContainersList(IAtom atom) {
        int i;
        ArrayList<IElectronContainer> lps = new ArrayList<IElectronContainer>();
        for (i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom)) continue;
            lps.add(this.bonds[i]);
        }
        for (i = 0; i < this.lonePairCount; ++i) {
            if (!this.lonePairs[i].contains(atom)) continue;
            lps.add(this.lonePairs[i]);
        }
        for (i = 0; i < this.singleElectronCount; ++i) {
            if (!this.singleElectrons[i].contains(atom)) continue;
            lps.add(this.singleElectrons[i]);
        }
        return lps;
    }

    @Override
    public int getConnectedAtomsCount(IAtom atom) {
        int count = 0;
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getConnectedBondsCount(IAtom atom) {
        return this.getConnectedAtomsCount(atom);
    }

    @Override
    public int getConnectedBondsCount(int atomNumber) {
        return this.getConnectedAtomsCount(this.atoms[atomNumber]);
    }

    @Override
    public int getConnectedLonePairsCount(IAtom atom) {
        int count = 0;
        for (int i = 0; i < this.lonePairCount; ++i) {
            if (!this.lonePairs[i].contains(atom)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getConnectedSingleElectronsCount(IAtom atom) {
        int count = 0;
        for (int i = 0; i < this.singleElectronCount; ++i) {
            if (!this.singleElectrons[i].contains(atom)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public double getBondOrderSum(IAtom atom) {
        double count = 0.0;
        for (int i = 0; i < this.bondCount; ++i) {
            IBond.Order order;
            if (!this.bonds[i].contains(atom) || (order = this.bonds[i].getOrder()) == null) continue;
            count += (double)order.numeric().intValue();
        }
        return count;
    }

    @Override
    public IBond.Order getMaximumBondOrder(IAtom atom) {
        IBond.Order max = IBond.Order.SINGLE;
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom) || this.bonds[i].getOrder().numeric() <= max.numeric()) continue;
            max = this.bonds[i].getOrder();
        }
        return max;
    }

    @Override
    public IBond.Order getMinimumBondOrder(IAtom atom) {
        IBond.Order min = IBond.Order.QUADRUPLE;
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom) || this.bonds[i].getOrder().numeric() >= min.numeric()) continue;
            min = this.bonds[i].getOrder();
        }
        return min;
    }

    @Override
    public void add(IAtomContainer atomContainer) {
        int f;
        for (f = 0; f < atomContainer.getAtomCount(); ++f) {
            if (this.contains(atomContainer.getAtom(f))) continue;
            this.addAtom(atomContainer.getAtom(f));
        }
        for (f = 0; f < atomContainer.getBondCount(); ++f) {
            if (this.contains(atomContainer.getBond(f))) continue;
            this.addBond(atomContainer.getBond(f));
        }
        for (f = 0; f < atomContainer.getLonePairCount(); ++f) {
            if (this.contains(atomContainer.getLonePair(f))) continue;
            this.addLonePair(atomContainer.getLonePair(f));
        }
        for (f = 0; f < atomContainer.getSingleElectronCount(); ++f) {
            if (this.contains(atomContainer.getSingleElectron(f))) continue;
            this.addSingleElectron(atomContainer.getSingleElectron(f));
        }
        for (IStereoElement se : atomContainer.stereoElements()) {
            this.stereoElements.add(se);
        }
    }

    @Override
    public void addAtom(IAtom atom) {
        if (this.contains(atom)) {
            return;
        }
        if (this.atomCount + 1 >= this.atoms.length) {
            this.growAtomArray();
        }
        this.atoms[this.atomCount] = atom;
        ++this.atomCount;
    }

    @Override
    public void addBond(IBond bond) {
        if (this.bondCount >= this.bonds.length) {
            this.growBondArray();
        }
        this.bonds[this.bondCount] = bond;
        ++this.bondCount;
    }

    @Override
    public void addLonePair(ILonePair lonePair) {
        if (this.lonePairCount >= this.lonePairs.length) {
            this.growLonePairArray();
        }
        this.lonePairs[this.lonePairCount] = lonePair;
        ++this.lonePairCount;
    }

    @Override
    public void addSingleElectron(ISingleElectron singleElectron) {
        if (this.singleElectronCount >= this.singleElectrons.length) {
            this.growSingleElectronArray();
        }
        this.singleElectrons[this.singleElectronCount] = singleElectron;
        ++this.singleElectronCount;
    }

    @Override
    public void addElectronContainer(IElectronContainer electronContainer) {
        if (electronContainer instanceof IBond) {
            this.addBond((IBond)electronContainer);
        }
        if (electronContainer instanceof ILonePair) {
            this.addLonePair((ILonePair)electronContainer);
        }
        if (electronContainer instanceof ISingleElectron) {
            this.addSingleElectron((ISingleElectron)electronContainer);
        }
    }

    @Override
    public void remove(IAtomContainer atomContainer) {
        int f;
        for (f = 0; f < atomContainer.getAtomCount(); ++f) {
            this.removeAtom(atomContainer.getAtom(f));
        }
        for (f = 0; f < atomContainer.getBondCount(); ++f) {
            this.removeBond(atomContainer.getBond(f));
        }
        for (f = 0; f < atomContainer.getLonePairCount(); ++f) {
            this.removeLonePair(atomContainer.getLonePair(f));
        }
        for (f = 0; f < atomContainer.getSingleElectronCount(); ++f) {
            this.removeSingleElectron(atomContainer.getSingleElectron(f));
        }
    }

    @Override
    public void removeAtom(int position) {
        for (int i = position; i < this.atomCount - 1; ++i) {
            this.atoms[i] = this.atoms[i + 1];
        }
        this.atoms[this.atomCount - 1] = null;
        --this.atomCount;
    }

    @Override
    public void removeAtom(IAtom atom) {
        int position = this.getAtomNumber(atom);
        if (position != -1) {
            this.removeAtom(position);
        }
    }

    @Override
    public IBond removeBond(int position) {
        IBond bond = this.bonds[position];
        bond.removeListener(this);
        for (int i = position; i < this.bondCount - 1; ++i) {
            this.bonds[i] = this.bonds[i + 1];
        }
        this.bonds[this.bondCount - 1] = null;
        --this.bondCount;
        return bond;
    }

    @Override
    public IBond removeBond(IAtom atom1, IAtom atom2) {
        int pos = this.getBondNumber(atom1, atom2);
        IBond bond = null;
        if (pos != -1) {
            bond = this.bonds[pos];
            this.removeBond(pos);
        }
        return bond;
    }

    @Override
    public void removeBond(IBond bond) {
        int pos = this.getBondNumber(bond);
        if (pos != -1) {
            this.removeBond(pos);
        }
    }

    @Override
    public ILonePair removeLonePair(int position) {
        ILonePair lp = this.lonePairs[position];
        for (int i = position; i < this.lonePairCount - 1; ++i) {
            this.lonePairs[i] = this.lonePairs[i + 1];
        }
        this.lonePairs[this.lonePairCount - 1] = null;
        --this.lonePairCount;
        return lp;
    }

    @Override
    public void removeLonePair(ILonePair lonePair) {
        int pos = this.getLonePairNumber(lonePair);
        if (pos != -1) {
            this.removeLonePair(pos);
        }
    }

    @Override
    public ISingleElectron removeSingleElectron(int position) {
        ISingleElectron se = this.singleElectrons[position];
        for (int i = position; i < this.singleElectronCount - 1; ++i) {
            this.singleElectrons[i] = this.singleElectrons[i + 1];
        }
        this.singleElectrons[this.singleElectronCount - 1] = null;
        --this.singleElectronCount;
        return se;
    }

    @Override
    public void removeSingleElectron(ISingleElectron singleElectron) {
        int pos = this.getSingleElectronNumber(singleElectron);
        if (pos != -1) {
            this.removeSingleElectron(pos);
        }
    }

    @Override
    public IElectronContainer removeElectronContainer(int number) {
        if (number < this.bondCount) {
            return this.removeBond(number);
        }
        if ((number -= this.bondCount) < this.lonePairCount) {
            return this.removeLonePair(number);
        }
        if ((number -= this.lonePairCount) < this.singleElectronCount) {
            return this.removeSingleElectron(number);
        }
        return null;
    }

    @Override
    public void removeElectronContainer(IElectronContainer electronContainer) {
        if (electronContainer instanceof IBond) {
            this.removeBond((IBond)electronContainer);
        } else if (electronContainer instanceof ILonePair) {
            this.removeLonePair((ILonePair)electronContainer);
        } else if (electronContainer instanceof ISingleElectron) {
            this.removeSingleElectron((ISingleElectron)electronContainer);
        }
    }

    @Override
    public void removeAtomAndConnectedElectronContainers(IAtom atom) {
        int position = this.getAtomNumber(atom);
        if (position != -1) {
            int i;
            for (i = 0; i < this.bondCount; ++i) {
                if (!this.bonds[i].contains(atom)) continue;
                this.removeBond(i);
                --i;
            }
            for (i = 0; i < this.lonePairCount; ++i) {
                if (!this.lonePairs[i].contains(atom)) continue;
                this.removeLonePair(i);
                --i;
            }
            for (i = 0; i < this.singleElectronCount; ++i) {
                if (!this.singleElectrons[i].contains(atom)) continue;
                this.removeSingleElectron(i);
                --i;
            }
            ArrayList<IStereoElement> atomElements = new ArrayList<IStereoElement>(3);
            for (IStereoElement element : this.stereoElements) {
                if (!element.contains(atom)) continue;
                atomElements.add(element);
            }
            this.stereoElements.removeAll(atomElements);
            this.removeAtom(position);
        }
    }

    @Override
    public void removeAllElements() {
        this.removeAllElectronContainers();
        this.atoms = new IAtom[this.growArraySize];
        this.atomCount = 0;
        this.stereoElements.clear();
    }

    @Override
    public void removeAllElectronContainers() {
        this.removeAllBonds();
        this.lonePairs = new ILonePair[this.growArraySize];
        this.singleElectrons = new ISingleElectron[this.growArraySize];
        this.lonePairCount = 0;
        this.singleElectronCount = 0;
    }

    @Override
    public void removeAllBonds() {
        this.bonds = new IBond[this.growArraySize];
        this.bondCount = 0;
    }

    @Override
    public void addBond(int atom1, int atom2, IBond.Order order, IBond.Stereo stereo) {
        IBond bond = this.getBuilder().newInstance(IBond.class, new Object[]{this.getAtom(atom1), this.getAtom(atom2), order, stereo});
        this.addBond(bond);
    }

    @Override
    public void addBond(int atom1, int atom2, IBond.Order order) {
        IBond bond = this.getBuilder().newInstance(IBond.class, new Object[]{this.getAtom(atom1), this.getAtom(atom2), order});
        this.addBond(bond);
    }

    @Override
    public void addLonePair(int atomID) {
        ILonePair lonePair = this.getBuilder().newInstance(ILonePair.class, this.atoms[atomID]);
        this.addLonePair(lonePair);
    }

    @Override
    public void addSingleElectron(int atomID) {
        ISingleElectron singleElectron = this.getBuilder().newInstance(ISingleElectron.class, this.atoms[atomID]);
        this.addSingleElectron(singleElectron);
    }

    @Override
    public boolean contains(IAtom atom) {
        for (int i = 0; i < this.getAtomCount(); ++i) {
            if (atom != this.atoms[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(IBond bond) {
        for (int i = 0; i < this.getBondCount(); ++i) {
            if (bond != this.bonds[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(ILonePair lonePair) {
        for (int i = 0; i < this.getLonePairCount(); ++i) {
            if (lonePair != this.lonePairs[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(ISingleElectron singleElectron) {
        for (int i = 0; i < this.getSingleElectronCount(); ++i) {
            if (singleElectron != this.singleElectrons[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(IElectronContainer electronContainer) {
        if (electronContainer instanceof IBond) {
            return this.contains((IBond)electronContainer);
        }
        if (electronContainer instanceof ILonePair) {
            return this.contains((ILonePair)electronContainer);
        }
        if (electronContainer instanceof ISingleElectron) {
            return this.contains((SingleElectron)electronContainer);
        }
        return false;
    }

    @Override
    public String toString() {
        int i;
        StringBuffer stringContent = new StringBuffer(64);
        stringContent.append("AtomContainer(");
        stringContent.append(this.hashCode());
        if (this.getAtomCount() > 0) {
            stringContent.append(", #A:").append(this.getAtomCount());
            for (i = 0; i < this.getAtomCount(); ++i) {
                stringContent.append(", ").append(this.getAtom(i).toString());
            }
        }
        if (this.getBondCount() > 0) {
            stringContent.append(", #B:").append(this.getBondCount());
            for (i = 0; i < this.getBondCount(); ++i) {
                stringContent.append(", ").append(this.getBond(i).toString());
            }
        }
        if (this.getLonePairCount() > 0) {
            stringContent.append(", #LP:").append(this.getLonePairCount());
            for (i = 0; i < this.getLonePairCount(); ++i) {
                stringContent.append(", ").append(this.getLonePair(i).toString());
            }
        }
        if (this.getSingleElectronCount() > 0) {
            stringContent.append(", #SE:").append(this.getSingleElectronCount());
            for (i = 0; i < this.getSingleElectronCount(); ++i) {
                stringContent.append(", ").append(this.getSingleElectron(i).toString());
            }
        }
        if (this.stereoElements.size() > 0) {
            stringContent.append(", ST:[#").append(this.stereoElements.size());
            for (IStereoElement elements : this.stereoElements) {
                stringContent.append(", ").append(elements.toString());
            }
            stringContent.append(']');
        }
        stringContent.append(')');
        return stringContent.toString();
    }

    @Override
    public IAtomContainer clone() throws CloneNotSupportedException {
        IElectronContainer original;
        int i;
        IAtomContainer clone = (IAtomContainer)super.clone();
        clone.setStereoElements(new ArrayList<IStereoElement>(this.stereoElements.size()));
        clone.removeAllElements();
        HashMap<IAtom, IAtom> atomMap = new HashMap<IAtom, IAtom>(this.atomCount >= 3 ? this.atomCount + this.atomCount / 3 : this.atomCount + 1);
        HashMap<IBond, IBond> bondMap = new HashMap<IBond, IBond>(this.bondCount >= 3 ? this.bondCount + this.bondCount / 3 : this.bondCount + 1);
        IAtom[] atoms = new IAtom[this.atomCount];
        for (int i2 = 0; i2 < atoms.length; ++i2) {
            atoms[i2] = this.atoms[i2].clone();
            atomMap.put(this.atoms[i2], atoms[i2]);
        }
        clone.setAtoms(atoms);
        IBond[] bonds = new IBond[this.bondCount];
        for (i = 0; i < bonds.length; ++i) {
            original = this.bonds[i];
            IBond bond = original.clone();
            int n = bond.getAtomCount();
            IAtom[] members = new IAtom[n];
            for (int j = 0; j < n; ++j) {
                members[j] = (IAtom)atomMap.get(original.getAtom(j));
            }
            bond.setAtoms(members);
            bondMap.put(this.bonds[i], bond);
            bonds[i] = bond;
        }
        clone.setBonds(bonds);
        for (i = 0; i < this.lonePairCount; ++i) {
            original = this.lonePairs[i];
            ILonePair pair2 = (ILonePair)original.clone();
            if (pair2.getAtom() != null) {
                pair2.setAtom((IAtom)atomMap.get(original.getAtom()));
            }
            clone.addLonePair(pair2);
        }
        for (i = 0; i < this.singleElectronCount; ++i) {
            original = this.singleElectrons[i];
            ISingleElectron electron = (ISingleElectron)original.clone();
            if (electron.getAtom() != null) {
                electron.setAtom((IAtom)atomMap.get(original.getAtom()));
            }
            clone.addSingleElectron(electron);
        }
        for (IStereoElement element : this.stereoElements) {
            clone.addStereoElement(element.map(atomMap, bondMap));
        }
        return clone;
    }

    private void growAtomArray() {
        this.growArraySize = this.atoms.length < this.growArraySize ? this.growArraySize : this.atoms.length;
        IAtom[] newatoms = new IAtom[this.atoms.length + this.growArraySize];
        System.arraycopy(this.atoms, 0, newatoms, 0, this.atoms.length);
        this.atoms = newatoms;
    }

    private void growBondArray() {
        this.growArraySize = this.bonds.length < this.growArraySize ? this.growArraySize : this.bonds.length;
        IBond[] newBonds = new IBond[this.bonds.length + this.growArraySize];
        System.arraycopy(this.bonds, 0, newBonds, 0, this.bonds.length);
        this.bonds = newBonds;
    }

    private void growLonePairArray() {
        this.growArraySize = this.lonePairs.length < this.growArraySize ? this.growArraySize : this.lonePairs.length;
        ILonePair[] newLonePairs = new ILonePair[this.lonePairs.length + this.growArraySize];
        System.arraycopy(this.lonePairs, 0, newLonePairs, 0, this.lonePairs.length);
        this.lonePairs = newLonePairs;
    }

    private void growSingleElectronArray() {
        this.growArraySize = this.singleElectrons.length < this.growArraySize ? this.growArraySize : this.singleElectrons.length;
        ISingleElectron[] newSingleElectrons = new ISingleElectron[this.singleElectrons.length + this.growArraySize];
        System.arraycopy(this.singleElectrons, 0, newSingleElectrons, 0, this.singleElectrons.length);
        this.singleElectrons = newSingleElectrons;
    }

    @Override
    public void stateChanged(IChemObjectChangeEvent event) {
    }

    @Override
    @TestMethod(value="testIsEmpty")
    public boolean isEmpty() {
        return this.atomCount == 0;
    }

    private class ElectronContainerIterator
    implements Iterator<IElectronContainer> {
        private int pointer = 0;

        private ElectronContainerIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < AtomContainer.this.bondCount + AtomContainer.this.lonePairCount + AtomContainer.this.singleElectronCount;
        }

        @Override
        public IElectronContainer next() {
            if (this.pointer < AtomContainer.this.bondCount) {
                return AtomContainer.this.bonds[this.pointer++];
            }
            if (this.pointer < AtomContainer.this.bondCount + AtomContainer.this.lonePairCount) {
                return AtomContainer.this.lonePairs[this.pointer++ - AtomContainer.this.bondCount];
            }
            if (this.pointer < AtomContainer.this.bondCount + AtomContainer.this.lonePairCount + AtomContainer.this.singleElectronCount) {
                return AtomContainer.this.singleElectrons[this.pointer++ - AtomContainer.this.bondCount - AtomContainer.this.lonePairCount];
            }
            return null;
        }

        @Override
        public void remove() {
            if (this.pointer <= AtomContainer.this.bondCount) {
                AtomContainer.this.removeBond(--this.pointer);
            } else if (this.pointer <= AtomContainer.this.bondCount + AtomContainer.this.lonePairCount) {
                AtomContainer.this.removeLonePair(--this.pointer - AtomContainer.this.bondCount);
            } else if (this.pointer <= AtomContainer.this.bondCount + AtomContainer.this.lonePairCount + AtomContainer.this.singleElectronCount) {
                AtomContainer.this.removeSingleElectron(--this.pointer - AtomContainer.this.bondCount - AtomContainer.this.lonePairCount);
            }
        }
    }

    private class SingleElectronIterator
    implements Iterator<ISingleElectron> {
        private int pointer = 0;

        private SingleElectronIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < AtomContainer.this.singleElectronCount;
        }

        @Override
        public ISingleElectron next() {
            return AtomContainer.this.singleElectrons[this.pointer++];
        }

        @Override
        public void remove() {
            AtomContainer.this.removeSingleElectron(--this.pointer);
        }
    }

    private class LonePairIterator
    implements Iterator<ILonePair> {
        private int pointer = 0;

        private LonePairIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < AtomContainer.this.lonePairCount;
        }

        @Override
        public ILonePair next() {
            return AtomContainer.this.lonePairs[this.pointer++];
        }

        @Override
        public void remove() {
            AtomContainer.this.removeLonePair(--this.pointer);
        }
    }

    private class BondIterator
    implements Iterator<IBond> {
        private int pointer = 0;

        private BondIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < AtomContainer.this.bondCount;
        }

        @Override
        public IBond next() {
            return AtomContainer.this.bonds[this.pointer++];
        }

        @Override
        public void remove() {
            AtomContainer.this.removeBond(--this.pointer);
        }
    }

    private class AtomIterator
    implements Iterator<IAtom> {
        private int pointer = 0;

        private AtomIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < AtomContainer.this.atomCount;
        }

        @Override
        public IAtom next() {
            return AtomContainer.this.atoms[this.pointer++];
        }

        @Override
        public void remove() {
            AtomContainer.this.removeAtom(--this.pointer);
        }
    }
}

