/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.util.Arrays;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.AtomMatcher;
import org.openscience.cdk.isomorphism.BondMatcher;
import org.openscience.cdk.isomorphism.CompatibilityMatrix;
import org.openscience.cdk.isomorphism.State;

@TestClass(value="org.openscience.cdk.isomorphism.UllmannStateTest")
final class UllmannState
extends State {
    final int[][] g1;
    final int[][] g2;
    private final GraphUtil.EdgeToBondMap bond1;
    private final GraphUtil.EdgeToBondMap bonds2;
    final CompatibilityMatrix matrix;
    final int[] m1;
    final int[] m2;
    int size = 0;
    private final BondMatcher bondMatcher;
    private static int UNMAPPED = -1;

    public UllmannState(IAtomContainer container1, IAtomContainer container2, int[][] g1, int[][] g2, GraphUtil.EdgeToBondMap bonds1, GraphUtil.EdgeToBondMap bonds2, AtomMatcher atomMatcher, BondMatcher bondMatcher) {
        this.bondMatcher = bondMatcher;
        this.g1 = g1;
        this.g2 = g2;
        this.bond1 = bonds1;
        this.bonds2 = bonds2;
        this.m1 = new int[g1.length];
        this.m2 = new int[g2.length];
        Arrays.fill(this.m1, UNMAPPED);
        Arrays.fill(this.m2, UNMAPPED);
        this.matrix = new CompatibilityMatrix(g1.length, g2.length);
        for (int i = 0; i < g1.length; ++i) {
            for (int j = 0; j < g2.length; ++j) {
                if (g1[i].length > g2[j].length || !atomMatcher.matches(container1.getAtom(i), container2.getAtom(j))) continue;
                this.matrix.set(i, j);
            }
        }
    }

    @Override
    int nextN(int n) {
        return this.size;
    }

    @Override
    int nextM(int n, int m) {
        for (int i = m + 1; i < this.g2.length; ++i) {
            if (this.m2[i] != UNMAPPED) continue;
            return i;
        }
        return this.g2.length;
    }

    @Override
    @TestMethod(value="accessors")
    int nMax() {
        return this.g1.length;
    }

    @Override
    @TestMethod(value="accessors")
    int mMax() {
        return this.g2.length;
    }

    @Override
    boolean add(int n, int m) {
        if (!this.matrix.get(n, m)) {
            return false;
        }
        this.matrix.markRow(n, -(n + 1));
        this.matrix.set(n, m);
        if (this.refine(n)) {
            ++this.size;
            this.m1[n] = m;
            this.m2[m] = n;
            return true;
        }
        this.matrix.resetRows(n, -(n + 1));
        return false;
    }

    @Override
    void remove(int n, int m) {
        --this.size;
        this.m1[n] = this.m2[m] = UNMAPPED;
        this.matrix.resetRows(n, -(n + 1));
    }

    private boolean refine(int row) {
        boolean changed;
        int marking = -(row + 1);
        do {
            changed = false;
            for (int n = row + 1; n < this.matrix.nRows; ++n) {
                for (int m = 0; m < this.matrix.mCols; ++m) {
                    if (!this.matrix.get(n, m) || this.verify(n, m)) continue;
                    this.matrix.mark(n, m, marking);
                    changed = true;
                    if (this.hasCandidate(n)) continue;
                    return false;
                }
            }
        } while (changed);
        return true;
    }

    private boolean verify(int n, int m) {
        for (int n_prime : this.g1[n]) {
            boolean found = false;
            for (int m_prime : this.g2[m]) {
                if (!this.matrix.get(n_prime, m_prime) || !this.bondMatcher.matches(this.bond1.get(n, n_prime), this.bonds2.get(m, m_prime))) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean hasCandidate(int n) {
        int j;
        int end = j + this.matrix.mCols;
        for (j = n * this.matrix.mCols; j < end; ++j) {
            if (!this.matrix.get(j)) continue;
            return true;
        }
        return false;
    }

    @Override
    int[] mapping() {
        return Arrays.copyOf(this.m1, this.m1.length);
    }

    @Override
    @TestMethod(value="accessors")
    int size() {
        return this.size;
    }
}

