/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

@TestClass(value="org.openscience.cdk.io.cml.CMLStackTest")
final class CMLStack {
    private String[] stack = new String[64];
    private int sp = 0;

    CMLStack() {
    }

    @TestMethod(value="testPush_String")
    void push(String item) {
        if (this.sp == this.stack.length) {
            String[] temp = new String[2 * this.sp];
            System.arraycopy(this.stack, 0, temp, 0, this.sp);
            this.stack = temp;
        }
        this.stack[this.sp++] = item;
    }

    int length() {
        return this.sp;
    }

    @TestMethod(value="testPop")
    String pop() {
        return this.stack[--this.sp];
    }

    @TestMethod(value="testCurrent")
    String current() {
        if (this.sp > 0) {
            return this.stack[this.sp - 1];
        }
        return "";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("/");
        for (int i = 0; i < this.sp; ++i) {
            sb.append(this.stack[i]);
            sb.append("/");
        }
        return sb.toString();
    }

    @TestMethod(value="testEndsWith_String")
    boolean endsWith(String lastElement) {
        return this.stack[this.sp - 1].equals(lastElement);
    }

    @TestMethod(value="testEndsWith_String_String")
    boolean endsWith(String oneButLast, String lastElement) {
        return this.endsWith(lastElement) && this.stack[this.sp - 2].equals(oneButLast);
    }

    @TestMethod(value="testEndsWith_String_String_String")
    boolean endsWith(String twoButLast, String oneButLast, String lastElement) {
        return this.endsWith(oneButLast, lastElement) && this.stack[this.sp - 3].equals(twoButLast);
    }

    @TestMethod(value="testSize")
    int size() {
        return this.sp;
    }
}

