/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.CMLRSSFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.libio.cml.Convertor;
import org.xmlcml.cml.base.CMLElement;

@TestClass(value="org.openscience.cdk.io.RssWriterTest")
public class RssWriter
extends DefaultChemObjectWriter {
    private static final String NS_RSS10 = "http://purl.org/rss/1.0/";
    private static final String NS_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String NS_DCELEMENTS = "http://purl.org/dc/elements/1.1/";
    private BufferedWriter writer;
    private Map linkmap = new HashMap();
    private Map datemap = new HashMap();
    private Map titlemap = new HashMap();
    private Map creatormap = new HashMap();
    private Map inchimap = new HashMap();
    private String creator = "";
    private String title = "";
    private String link = "";
    private String description = "";
    private String publisher = "";
    private String imagelink = "";
    private String about = "";
    private String timezone = "+01:00";
    private Map multiMap = new HashMap();

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return CMLRSSFormat.getInstance();
    }

    @Override
    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    @Override
    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    @Override
    @TestMethod(value="testAccepts")
    public boolean accepts(Class<? extends IChemObject> classObject) {
        return true;
    }

    @Override
    public void write(IChemObject object) throws CDKException {
        try {
            int i;
            ProcessingInstruction processingInstruction = new ProcessingInstruction("xml-stylesheet", "href=\"http://www.w3.org/2000/08/w3c-synd/style.css\" type=\"text/css\"");
            Element rdfElement = new Element("rdf:RDF", NS_RDF);
            rdfElement.addNamespaceDeclaration("", NS_RSS10);
            rdfElement.addNamespaceDeclaration("mn", "http://usefulinc.com/rss/manifest/");
            rdfElement.addNamespaceDeclaration("dc", NS_DCELEMENTS);
            rdfElement.addNamespaceDeclaration("cml", "http://www.xml-cml.org/schema");
            Document doc = new Document(rdfElement);
            doc.insertChild(processingInstruction, 0);
            Element channelElement = new Element("channel", NS_RSS10);
            Element titleElement = new Element("title", NS_RSS10);
            titleElement.appendChild(new Text(this.title));
            channelElement.appendChild(titleElement);
            Element linkElement = new Element("link", NS_RSS10);
            linkElement.appendChild(new Text(this.link));
            channelElement.appendChild(linkElement);
            Element descriptionElement = new Element("description", NS_RSS10);
            descriptionElement.appendChild(new Text(this.description));
            channelElement.appendChild(descriptionElement);
            Element publisherElement = new Element("dc:publisher", NS_DCELEMENTS);
            publisherElement.appendChild(new Text(this.publisher));
            channelElement.appendChild(publisherElement);
            Element creatorElement = new Element("dc:creator", NS_DCELEMENTS);
            creatorElement.appendChild(new Text(this.creator));
            channelElement.appendChild(creatorElement);
            Element imageElement = new Element("image", NS_RSS10);
            imageElement.addAttribute(new Attribute("rdf:resource", NS_RDF, this.imagelink));
            channelElement.appendChild(imageElement);
            Element itemsElement = new Element("items", NS_RSS10);
            Element seqElement = new Element("rdf:Seq", NS_RDF);
            itemsElement.appendChild(seqElement);
            channelElement.appendChild(itemsElement);
            channelElement.addAttribute(new Attribute("rdf:about", NS_RDF, this.about));
            rdfElement.appendChild(channelElement);
            Vector<IChemObject> list = new Vector<IChemObject>();
            if (object instanceof IAtomContainerSet) {
                for (i = 0; i < ((IAtomContainerSet)object).getAtomContainerCount(); ++i) {
                    list.add(((IAtomContainerSet)object).getAtomContainer(i));
                }
            } else {
                list.add(object);
            }
            for (i = 0; i < list.size(); ++i) {
                IChemObject chemObject = (IChemObject)list.get(i);
                Element itemElement = new Element("item", NS_RSS10);
                String easylink = (String)this.linkmap.get(chemObject);
                if (easylink != null) {
                    itemElement.addAttribute(new Attribute("rdf:about", NS_RDF, easylink));
                }
                Element link2Element = new Element("link", NS_RSS10);
                link2Element.appendChild(new Text(easylink));
                itemElement.appendChild(link2Element);
                String title = (String)chemObject.getProperties().get("cdk:Title");
                if (this.titlemap.get(chemObject) != null) {
                    Element title2Element = new Element("title", NS_RSS10);
                    title2Element.appendChild(new Text((String)this.titlemap.get(chemObject)));
                    itemElement.appendChild(title2Element);
                }
                if (title != null) {
                    Element description2Element = new Element("description", NS_RSS10);
                    description2Element.appendChild(new Text(title));
                    itemElement.appendChild(description2Element);
                    Element subjectElement = new Element("dc:subject", NS_DCELEMENTS);
                    subjectElement.appendChild(new Text(title));
                    itemElement.appendChild(subjectElement);
                }
                if (this.datemap.get(chemObject) != null) {
                    Element dateElement = new Element("dc:date", NS_DCELEMENTS);
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
                    dateElement.appendChild(new Text(formatter.format((Date)this.datemap.get(chemObject)) + this.timezone));
                    itemElement.appendChild(dateElement);
                }
                Element creator2Element = new Element("dc:creator", NS_DCELEMENTS);
                creator2Element.appendChild(new Text((String)this.creatormap.get(chemObject)));
                itemElement.appendChild(creator2Element);
                if (this.inchimap.get(chemObject) != null) {
                    Element inchiElement = new Element("cml:identifier", "http://www.xml-cml.org/schema/cml2/core/");
                    inchiElement.appendChild(new Text((String)this.inchimap.get(chemObject)));
                    itemElement.appendChild(inchiElement);
                }
                CMLElement root = null;
                Convertor convertor = new Convertor(true, null);
                object = (IChemObject)list.get(i);
                if (object instanceof IAtomContainer) {
                    root = convertor.cdkAtomContainerToCMLMolecule((IAtomContainer)object);
                } else if (object instanceof ICrystal) {
                    root = convertor.cdkCrystalToCMLMolecule((ICrystal)object);
                } else if (object instanceof IAtom) {
                    root = convertor.cdkAtomToCMLAtom(null, (IAtom)object);
                } else if (object instanceof IBond) {
                    root = convertor.cdkBondToCMLBond((IBond)object);
                } else if (object instanceof IReaction) {
                    root = convertor.cdkReactionToCMLReaction((IReaction)object);
                } else if (object instanceof IReactionSet) {
                    root = convertor.cdkReactionSetToCMLReactionList((IReactionSet)object);
                } else if (object instanceof IAtomContainerSet) {
                    root = convertor.cdkAtomContainerSetToCMLList((IAtomContainerSet)object);
                } else if (object instanceof IChemSequence) {
                    root = convertor.cdkChemSequenceToCMLList((IChemSequence)object);
                } else if (object instanceof IChemModel) {
                    root = convertor.cdkChemModelToCMLList((IChemModel)object);
                } else if (object instanceof IChemFile) {
                    root = convertor.cdkChemFileToCMLList((IChemFile)object);
                } else {
                    throw new CDKException("Unsupported chemObject: " + object.getClass().getName());
                }
                itemElement.appendChild(root);
                if (this.multiMap.get(chemObject) != null) {
                    Collection coll = (Collection)this.multiMap.get(chemObject);
                    Iterator iterator = coll.iterator();
                    while (iterator.hasNext()) {
                        itemElement.appendChild((Element)iterator.next());
                    }
                }
                rdfElement.appendChild(itemElement);
                Element imageElement2 = new Element("rdf:li", NS_RDF);
                imageElement2.addAttribute(new Attribute("rdf:resource", NS_RDF, (String)this.linkmap.get(chemObject)));
                seqElement.appendChild(imageElement2);
            }
            this.writer.write(doc.toXML());
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new CDKException(ex.getMessage(), ex);
        }
    }

    public Map getDatemap() {
        return this.datemap;
    }

    public void setDatemap(Map datemap) {
        this.datemap = datemap;
    }

    public Map getLinkmap() {
        return this.linkmap;
    }

    public void setLinkmap(Map linkmap) {
        this.linkmap = linkmap;
    }

    public Map getTitlemap() {
        return this.titlemap;
    }

    public void setTitlemap(Map titlemap) {
        this.titlemap = titlemap;
    }

    public Map getCreatormap() {
        return this.creatormap;
    }

    public void setCreatormap(Map creatormap) {
        this.creatormap = creatormap;
    }

    public void setAbout(String about) {
        this.about = about;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setImagelink(String imagelink) {
        this.imagelink = imagelink;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Map getMultiMap() {
        return this.multiMap;
    }

    public void setMultiMap(Map multiMap) {
        this.multiMap = multiMap;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public Map getInchimap() {
        return this.inchimap;
    }

    public void setInchimap(Map inchimap) {
        this.inchimap = inchimap;
    }
}

