/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.validate;

import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.validate.AbstractValidator;
import org.openscience.cdk.validate.ValidationReport;
import org.openscience.cdk.validate.ValidationTest;

public class Geometry3DValidator
extends AbstractValidator {
    public ValidationReport validateBond(IBond subject) {
        double distance;
        ValidationReport report = new ValidationReport();
        if (subject.getAtomCount() == 2 && (distance = subject.getAtom(0).getPoint3d().distance(subject.getAtom(2).getPoint3d())) > 3.0) {
            ValidationTest badBondLengthError = new ValidationTest(subject, "Bond length cannot exceed 3 Angstroms.", "A bond length typically is between 0.5 and 3.0 Angstroms.");
            report.addError(badBondLengthError);
        }
        return report;
    }
}

