/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.mcgregor;

import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smsd.algorithm.mcgregor.McGregorChecks;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.smsd.algorithm.mcgregor.TargetProcessorTest")
public class TargetProcessor {
    private List<String> cTab1Copy;
    private List<String> cTab2Copy;
    private String[] signArray;
    private int neighborBondNumB = 0;
    private int setBondNumB = 0;
    private List<Integer> iBondNeighborsB;
    private List<String> cBondNeighborsB;
    private int newNeighborNumA;
    private List<Integer> newINeighborsA;
    private List<String> newCNeighborsA;

    protected TargetProcessor(List<String> cTab1Copy, List<String> cTab2Copy, String[] signArray, int neighbor_bondnum_B, int set_bondnum_B, List<Integer> iBondNeighborsB, List<String> cBondNeighborsB, int newNeighborNumA, List<Integer> newINeighborsA, List<String> newCNeighborsA) {
        this.cTab1Copy = cTab1Copy;
        this.cTab2Copy = cTab2Copy;
        this.signArray = signArray;
        this.neighborBondNumB = neighbor_bondnum_B;
        this.setBondNumB = set_bondnum_B;
        this.iBondNeighborsB = iBondNeighborsB;
        this.cBondNeighborsB = cBondNeighborsB;
        this.newNeighborNumA = newNeighborNumA;
        this.newCNeighborsA = newCNeighborsA;
        this.newINeighborsA = newINeighborsA;
    }

    protected void process(IAtomContainer target, List<Integer> unmapped_atoms_molB, int mappingSize, List<Integer> i_bond_setB, List<String> c_bond_setB, List<Integer> mapped_atoms, int counter) {
        int unmapped_numB = unmapped_atoms_molB.size();
        boolean bond_considered = false;
        boolean normal_bond = true;
        for (int atomIndex = 0; atomIndex < target.getBondCount(); ++atomIndex) {
            Integer indexI = target.getAtomNumber(target.getBond(atomIndex).getAtom(0));
            Integer indexJ = target.getAtomNumber(target.getBond(atomIndex).getAtom(1));
            Integer order = target.getBond(atomIndex).getOrder().numeric();
            for (int b = 0; b < unmapped_numB; ++b) {
                if (unmapped_atoms_molB.get(b).equals(indexI)) {
                    normal_bond = this.unMappedAtomsEqualsIndexI(target, mappingSize, atomIndex, counter, mapped_atoms, indexI, indexJ, order);
                    bond_considered = true;
                } else if (unmapped_atoms_molB.get(b) == indexJ) {
                    normal_bond = this.unMappedAtomsEqualsIndexJ(target, mappingSize, atomIndex, counter, mapped_atoms, indexI, indexJ, order);
                    bond_considered = true;
                }
                if (!normal_bond || !bond_considered) continue;
                this.markNormalBonds(atomIndex, i_bond_setB, c_bond_setB, indexI, indexJ, order);
                normal_bond = true;
                break;
            }
            bond_considered = false;
        }
    }

    protected void process(int setNumB, List<Integer> unmapped_atoms_molB, int newMapingSize, List<Integer> i_bond_setB, List<String> c_bond_setB, List<Integer> new_Mapping, int counter, List<Integer> new_i_bond_setB, List<String> new_c_bond_setB) {
        boolean bond_considered = false;
        boolean normal_bond = true;
        for (int atomIndex = 0; atomIndex < setNumB; ++atomIndex) {
            Integer indexI = i_bond_setB.get(atomIndex * 3 + 0);
            Integer indexJ = i_bond_setB.get(atomIndex * 3 + 1);
            Integer order = i_bond_setB.get(atomIndex * 3 + 2);
            for (Integer unMappedAtomIndex : unmapped_atoms_molB) {
                if (unMappedAtomIndex.equals(indexI)) {
                    normal_bond = this.unMappedAtomsEqualsIndexI(setNumB, i_bond_setB, newMapingSize, atomIndex, counter, new_Mapping, indexI, indexJ, order);
                    bond_considered = true;
                } else if (unMappedAtomIndex.equals(indexJ)) {
                    normal_bond = this.unMappedAtomsEqualsIndexJ(setNumB, i_bond_setB, newMapingSize, atomIndex, counter, new_Mapping, indexI, indexJ, order);
                    bond_considered = true;
                }
                if (!normal_bond || !bond_considered) continue;
                this.markNormalBonds(atomIndex, new_i_bond_setB, new_c_bond_setB, indexI, indexJ, order);
                normal_bond = true;
                break;
            }
            bond_considered = false;
        }
    }

    private boolean unMappedAtomsEqualsIndexI(IAtomContainer target, int mappingSize, int atomIndex, int counter, List<Integer> mapped_atoms, Integer indexI, Integer indexJ, Integer order) {
        boolean normal_bond = true;
        for (int c = 0; c < mappingSize; ++c) {
            if (!mapped_atoms.get(c * 2 + 1).equals(indexJ)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab2Copy.get(atomIndex * 4 + 3).compareToIgnoreCase("X") == 0) {
                this.step1(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexJ, this.signArray[counter], target.getBondCount(), target, this.cTab2Copy);
                int cor_atom = McGregorChecks.searchCorrespondingAtom(mappingSize, indexJ, 2, mapped_atoms);
                McGregorChecks.changeCharBonds(cor_atom, this.signArray[counter], this.newNeighborNumA, this.newINeighborsA, this.newCNeighborsA);
                ++counter;
            } else {
                this.step2(atomIndex);
            }
            normal_bond = false;
            ++this.neighborBondNumB;
        }
        return normal_bond;
    }

    private boolean unMappedAtomsEqualsIndexJ(IAtomContainer target, int mappingSize, int atomIndex, int counter, List<Integer> mapped_atoms, Integer indexI, Integer indexJ, Integer order) {
        boolean normal_bond = true;
        for (int c = 0; c < mappingSize; ++c) {
            if (!mapped_atoms.get(c * 2 + 1).equals(indexI)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab2Copy.get(atomIndex * 4 + 2).compareToIgnoreCase("X") == 0) {
                this.step3(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexI, this.signArray[counter], target.getBondCount(), target, this.cTab2Copy);
                int cor_atom = McGregorChecks.searchCorrespondingAtom(mappingSize, indexI, 2, mapped_atoms);
                McGregorChecks.changeCharBonds(cor_atom, this.signArray[counter], this.newNeighborNumA, this.newINeighborsA, this.newCNeighborsA);
                ++counter;
            } else {
                this.step4(atomIndex);
            }
            normal_bond = false;
            ++this.neighborBondNumB;
        }
        return normal_bond;
    }

    private boolean unMappedAtomsEqualsIndexI(int setNumB, List<Integer> i_bond_setB, int newMappingSize, int atomIndex, int counter, List<Integer> new_Mapping, Integer indexI, Integer indexJ, Integer order) {
        boolean normal_bond = true;
        for (int c = 0; c < newMappingSize; ++c) {
            if (!new_Mapping.get(c * 2 + 1).equals(indexJ)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab2Copy.get(atomIndex * 4 + 3).compareToIgnoreCase("X") == 0) {
                this.step1(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexJ, this.signArray[counter], setNumB, i_bond_setB, this.cTab2Copy);
                int cor_atom = McGregorChecks.searchCorrespondingAtom(newMappingSize, indexJ, 2, new_Mapping);
                McGregorChecks.changeCharBonds(cor_atom, this.signArray[counter], this.newNeighborNumA, this.newINeighborsA, this.newCNeighborsA);
                ++counter;
            } else {
                this.step2(atomIndex);
            }
            normal_bond = false;
            ++this.neighborBondNumB;
        }
        return normal_bond;
    }

    private boolean unMappedAtomsEqualsIndexJ(int setNumB, List<Integer> i_bond_setB, int newMappingSize, int atomIndex, int counter, List<Integer> new_Mapping, Integer indexI, Integer indexJ, Integer order) {
        boolean normal_bond = true;
        for (int c = 0; c < newMappingSize; ++c) {
            if (!new_Mapping.get(c * 2 + 1).equals(indexI)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab2Copy.get(atomIndex * 4 + 2).compareToIgnoreCase("X") == 0) {
                this.step3(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexI, this.signArray[counter], setNumB, i_bond_setB, this.cTab2Copy);
                int cor_atom = McGregorChecks.searchCorrespondingAtom(newMappingSize, indexI, 2, new_Mapping);
                McGregorChecks.changeCharBonds(cor_atom, this.signArray[counter], this.newNeighborNumA, this.newINeighborsA, this.newCNeighborsA);
                ++counter;
            } else {
                this.step4(atomIndex);
            }
            normal_bond = false;
            ++this.neighborBondNumB;
        }
        return normal_bond;
    }

    private void markNormalBonds(int atomIndex, List<Integer> i_bond_setB, List<String> c_bond_setB, Integer indexI, Integer indexJ, Integer order) {
        i_bond_setB.add(indexI);
        i_bond_setB.add(indexJ);
        i_bond_setB.add(order);
        c_bond_setB.add(this.cTab2Copy.get(atomIndex * 4 + 0));
        c_bond_setB.add(this.cTab2Copy.get(atomIndex * 4 + 1));
        c_bond_setB.add("X");
        c_bond_setB.add("X");
        ++this.setBondNumB;
    }

    private void setBondNeighbors(Integer indexI, Integer indexJ, Integer order) {
        this.iBondNeighborsB.add(indexI);
        this.iBondNeighborsB.add(indexJ);
        this.iBondNeighborsB.add(order);
    }

    private void step1(int atomIndex, int counter) {
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsB.add(this.signArray[counter]);
        this.cBondNeighborsB.add("X");
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 1));
    }

    private void step2(int atomIndex) {
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 1));
        this.cBondNeighborsB.add("X");
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 3));
    }

    private void step3(int atomIndex, int counter) {
        this.cBondNeighborsB.add(this.signArray[counter]);
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 1));
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsB.add("X");
    }

    private void step4(int atomIndex) {
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 1));
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 2));
        this.cBondNeighborsB.add("X");
    }

    protected List<String> getCTab1() {
        return this.cTab1Copy;
    }

    protected List<String> getCTab2() {
        return this.cTab2Copy;
    }

    protected int getNeighborBondNumB() {
        return this.neighborBondNumB;
    }

    protected int getBondNumB() {
        return this.setBondNumB;
    }

    List<Integer> getIBondNeighboursB() {
        return this.iBondNeighborsB;
    }

    List<String> getCBondNeighborsB() {
        return this.cBondNeighborsB;
    }
}

