/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry;

import java.util.HashMap;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Projector {
    public static void project2D(IAtomContainer container) {
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = container.getAtom(i);
            if (atom.getPoint3d() == null) continue;
            atom.setPoint2d(new Point2d(atom.getPoint3d().x, atom.getPoint3d().y));
        }
    }

    public static void project2D(IAtomContainer container, HashMap<IAtom, Point2d> renderingCoordinates) {
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = container.getAtom(i);
            if (atom.getPoint3d() == null) continue;
            atom.setPoint2d(new Point2d(atom.getPoint3d().x, atom.getPoint3d().y));
            renderingCoordinates.put(atom, new Point2d(atom.getPoint3d().x, atom.getPoint3d().y));
        }
    }
}

