/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import org.openscience.cdk.DynamicFactory;
import org.openscience.cdk.debug.DebugAdductFormula;
import org.openscience.cdk.debug.DebugAminoAcid;
import org.openscience.cdk.debug.DebugAtom;
import org.openscience.cdk.debug.DebugAtomContainer;
import org.openscience.cdk.debug.DebugAtomContainerSet;
import org.openscience.cdk.debug.DebugAtomParity;
import org.openscience.cdk.debug.DebugAtomType;
import org.openscience.cdk.debug.DebugBioPolymer;
import org.openscience.cdk.debug.DebugBond;
import org.openscience.cdk.debug.DebugChemFile;
import org.openscience.cdk.debug.DebugChemModel;
import org.openscience.cdk.debug.DebugChemObject;
import org.openscience.cdk.debug.DebugChemSequence;
import org.openscience.cdk.debug.DebugCrystal;
import org.openscience.cdk.debug.DebugElectronContainer;
import org.openscience.cdk.debug.DebugElement;
import org.openscience.cdk.debug.DebugFragmentAtom;
import org.openscience.cdk.debug.DebugIsotope;
import org.openscience.cdk.debug.DebugLonePair;
import org.openscience.cdk.debug.DebugMapping;
import org.openscience.cdk.debug.DebugMolecularFormula;
import org.openscience.cdk.debug.DebugMolecularFormulaSet;
import org.openscience.cdk.debug.DebugMonomer;
import org.openscience.cdk.debug.DebugPDBAtom;
import org.openscience.cdk.debug.DebugPDBMonomer;
import org.openscience.cdk.debug.DebugPDBPolymer;
import org.openscience.cdk.debug.DebugPDBStructure;
import org.openscience.cdk.debug.DebugPolymer;
import org.openscience.cdk.debug.DebugPseudoAtom;
import org.openscience.cdk.debug.DebugReaction;
import org.openscience.cdk.debug.DebugReactionScheme;
import org.openscience.cdk.debug.DebugReactionSet;
import org.openscience.cdk.debug.DebugRing;
import org.openscience.cdk.debug.DebugRingSet;
import org.openscience.cdk.debug.DebugSingleElectron;
import org.openscience.cdk.debug.DebugStrand;
import org.openscience.cdk.interfaces.IAdductFormula;
import org.openscience.cdk.interfaces.IAminoAcid;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomParity;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBioPolymer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.ICDKObject;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IFragmentAtom;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IPDBAtom;
import org.openscience.cdk.interfaces.IPDBMonomer;
import org.openscience.cdk.interfaces.IPDBPolymer;
import org.openscience.cdk.interfaces.IPDBStructure;
import org.openscience.cdk.interfaces.IPolymer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionScheme;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStrand;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.DoubleBondStereochemistry;
import org.openscience.cdk.stereo.TetrahedralChirality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugChemObjectBuilder
implements IChemObjectBuilder {
    private static IChemObjectBuilder instance = null;
    private final DynamicFactory factory = new DynamicFactory(200);

    private DebugChemObjectBuilder() {
        final DebugChemObjectBuilder self = this;
        this.factory.register(IAtom.class, DebugAtom.class);
        this.factory.register(IPseudoAtom.class, DebugPseudoAtom.class);
        this.factory.register(IElement.class, DebugElement.class);
        this.factory.register(IAtomType.class, DebugAtomType.class);
        this.factory.register(IFragmentAtom.class, DebugFragmentAtom.class);
        this.factory.register(IPDBAtom.class, DebugPDBAtom.class);
        this.factory.register(IIsotope.class, DebugIsotope.class);
        this.factory.register(IBond.class, DebugBond.class);
        this.factory.register(IElectronContainer.class, DebugElectronContainer.class);
        this.factory.register(ISingleElectron.class, DebugSingleElectron.class);
        this.factory.register(ILonePair.class, DebugLonePair.class);
        this.factory.register(IAtomContainer.class, DebugAtomContainer.class);
        this.factory.register(IRing.class, DebugRing.class);
        this.factory.register(ICrystal.class, DebugCrystal.class);
        this.factory.register(IPolymer.class, DebugPolymer.class);
        this.factory.register(IPDBPolymer.class, DebugPDBPolymer.class);
        this.factory.register(IMonomer.class, DebugMonomer.class);
        this.factory.register(IPDBMonomer.class, DebugPDBMonomer.class);
        this.factory.register(IBioPolymer.class, DebugBioPolymer.class);
        this.factory.register(IPDBStructure.class, DebugPDBStructure.class);
        this.factory.register(IAminoAcid.class, DebugAminoAcid.class);
        this.factory.register(IStrand.class, DebugStrand.class);
        this.factory.register(IReaction.class, DebugReaction.class);
        this.factory.register(IReactionScheme.class, DebugReactionScheme.class);
        this.factory.register(IMolecularFormula.class, DebugMolecularFormula.class);
        this.factory.register(IAdductFormula.class, DebugAdductFormula.class);
        this.factory.register(IAtomContainerSet.class, DebugAtomContainerSet.class);
        this.factory.register(IMolecularFormulaSet.class, DebugMolecularFormulaSet.class);
        this.factory.register(IReactionSet.class, DebugReactionSet.class);
        this.factory.register(IRingSet.class, DebugRingSet.class);
        this.factory.register(IChemModel.class, DebugChemModel.class);
        this.factory.register(IChemFile.class, DebugChemFile.class);
        this.factory.register(IChemSequence.class, DebugChemSequence.class);
        this.factory.register(IAtomParity.class, DebugAtomParity.class);
        this.factory.register(ITetrahedralChirality.class, TetrahedralChirality.class, new DynamicFactory.CreationModifier<TetrahedralChirality>(){

            @Override
            public void modify(TetrahedralChirality instance) {
                instance.setBuilder(self);
            }
        });
        this.factory.register(IDoubleBondStereochemistry.class, DoubleBondStereochemistry.class, new DynamicFactory.CreationModifier<DoubleBondStereochemistry>(){

            @Override
            public void modify(DoubleBondStereochemistry instance) {
                instance.setBuilder(self);
            }
        });
        this.factory.register(IMapping.class, DebugMapping.class);
        this.factory.register(IChemObject.class, DebugChemObject.class);
    }

    public static IChemObjectBuilder getInstance() {
        if (instance == null) {
            instance = new DebugChemObjectBuilder();
        }
        return instance;
    }

    @Override
    public <T extends ICDKObject> T newInstance(Class<T> clazz, Object ... params) {
        return this.factory.ofClass(clazz, params);
    }
}

