/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.ringsearch.cyclebasis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.UndirectedGraph;
import org._3pq.jgrapht.alg.DijkstraShortestPath;
import org._3pq.jgrapht.graph.UndirectedSubgraph;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.BiconnectivityInspector;
import org.openscience.cdk.ringsearch.cyclebasis.SimpleCycle;
import org.openscience.cdk.ringsearch.cyclebasis.SimpleCycleBasis;

@TestClass(value="org.openscience.cdk.ringsearch.cyclebasis.CycleBasisTest")
public class CycleBasis {
    private List mulitEdgeCycles = new Vector();
    private List multiEdgeList = new Vector();
    private SimpleCycleBasis cachedCycleBasis;
    private UndirectedGraph baseGraph;
    private List subgraphBases = new Vector();

    public CycleBasis(UndirectedGraph g) {
        this.baseGraph = g;
        UndirectedSubgraph simpleGraph = new UndirectedSubgraph(g, null, null);
        for (Edge edge : g.edgeSet()) {
            Object v;
            Object u = edge.getSource();
            List edges = simpleGraph.getAllEdges(u, v = edge.getTarget());
            if (edges.size() <= 1) continue;
            Edge minEdge = edge;
            for (Edge nextEdge : edges) {
                minEdge = nextEdge.getWeight() < minEdge.getWeight() ? nextEdge : minEdge;
            }
            for (Edge nextEdge : edges) {
                if (nextEdge == minEdge) continue;
                simpleGraph.removeEdge(nextEdge);
                HashSet<Edge> edgesOfCycle = new HashSet<Edge>();
                edgesOfCycle.add(nextEdge);
                edgesOfCycle.addAll(DijkstraShortestPath.findPathBetween(simpleGraph, u, v));
                this.multiEdgeList.add(nextEdge);
                this.mulitEdgeCycles.add(new SimpleCycle(this.baseGraph, (Set)edgesOfCycle));
            }
        }
        List biconnectedComponents = new BiconnectivityInspector(simpleGraph).biconnectedSets();
        for (Set edges : biconnectedComponents) {
            if (edges.size() > 1) {
                HashSet<Object> vertices = new HashSet<Object>();
                for (Edge edge : edges) {
                    vertices.add(edge.getSource());
                    vertices.add(edge.getTarget());
                }
                UndirectedSubgraph subgraph = new UndirectedSubgraph(simpleGraph, vertices, edges);
                SimpleCycleBasis cycleBasis = new SimpleCycleBasis(subgraph);
                this.subgraphBases.add(cycleBasis);
                continue;
            }
            Edge edge = (Edge)edges.iterator().next();
            this.multiEdgeList.add(edge);
        }
    }

    @TestMethod(value="testWeightVector")
    public int[] weightVector() {
        SimpleCycleBasis basis = this.simpleBasis();
        List cycles = basis.cycles();
        int[] result = new int[cycles.size()];
        for (int i = 0; i < cycles.size(); ++i) {
            SimpleCycle cycle = (SimpleCycle)cycles.get(i);
            result[i] = (int)cycle.weight();
        }
        Arrays.sort(result);
        return result;
    }

    private SimpleCycleBasis simpleBasis() {
        if (this.cachedCycleBasis == null) {
            ArrayList<SimpleCycle> cycles = new ArrayList<SimpleCycle>();
            ArrayList edgeList = new ArrayList();
            for (Object subgraphBase1 : this.subgraphBases) {
                SimpleCycleBasis subgraphBase = (SimpleCycleBasis)subgraphBase1;
                cycles.addAll(subgraphBase.cycles());
                edgeList.addAll(subgraphBase.edges());
            }
            cycles.addAll(this.mulitEdgeCycles);
            edgeList.addAll(this.multiEdgeList);
            this.cachedCycleBasis = new SimpleCycleBasis(cycles, edgeList, this.baseGraph);
        }
        return this.cachedCycleBasis;
    }

    @TestMethod(value="testCycles")
    public Collection cycles() {
        return this.simpleBasis().cycles();
    }

    @TestMethod(value="testEssentialCycles")
    public Collection essentialCycles() {
        HashSet result = new HashSet();
        for (Object subgraphBase : this.subgraphBases) {
            SimpleCycleBasis cycleBasis = (SimpleCycleBasis)subgraphBase;
            result.addAll(cycleBasis.essentialCycles());
        }
        return result;
    }

    @TestMethod(value="testRelevantCycles")
    public Map relevantCycles() {
        HashMap result = new HashMap();
        for (Object subgraphBase : this.subgraphBases) {
            SimpleCycleBasis cycleBasis = (SimpleCycleBasis)subgraphBase;
            result.putAll(cycleBasis.relevantCycles());
        }
        return result;
    }

    @TestMethod(value="testEquivalenceClasses")
    public List equivalenceClasses() {
        ArrayList result = new ArrayList();
        for (Object subgraphBase : this.subgraphBases) {
            SimpleCycleBasis cycleBasis = (SimpleCycleBasis)subgraphBase;
            result.addAll(cycleBasis.equivalenceClasses());
        }
        return result;
    }
}

