/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.color;

import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.renderer.color.IAtomColorer;

@TestClass(value="org.openscience.cdk.renderer.color.RasmolColorsTest")
public class RasmolColors
implements IAtomColorer,
Serializable {
    private static final long serialVersionUID = 2588969984094169759L;
    private static final Color DEFAULT = new Color(255, 20, 147);
    private static Map<String, Color> colorMap = new HashMap<String, Color>();

    @TestMethod(value="testGetAtomColor")
    public Color getAtomColor(IAtom atom) {
        return this.getAtomColor(atom, DEFAULT);
    }

    @TestMethod(value="testGetDefaultAtomColor")
    public Color getAtomColor(IAtom atom, Color defaultColor) {
        Color color = defaultColor;
        String symbol = atom.getSymbol();
        if (colorMap.containsKey(symbol)) {
            color = colorMap.get(symbol);
        }
        return color;
    }

    static {
        colorMap.put("C", new Color(144, 144, 144));
        colorMap.put("H", new Color(144, 144, 144));
        colorMap.put("O", new Color(240, 0, 0));
        colorMap.put("N", new Color(143, 143, 255));
        colorMap.put("S", new Color(255, 200, 50));
        colorMap.put("Cl", new Color(0, 255, 0));
        colorMap.put("B", new Color(0, 255, 0));
        colorMap.put("P", new Color(255, 165, 0));
        colorMap.put("Fe", new Color(255, 165, 0));
        colorMap.put("Ba", new Color(255, 165, 0));
        colorMap.put("Na", new Color(0, 0, 255));
        colorMap.put("Mg", new Color(34, 139, 34));
        colorMap.put("Zn", new Color(165, 42, 42));
        colorMap.put("Cu", new Color(165, 42, 42));
        colorMap.put("Ni", new Color(165, 42, 42));
        colorMap.put("Br", new Color(165, 42, 42));
        colorMap.put("Ca", new Color(128, 128, 144));
        colorMap.put("Mn", new Color(128, 128, 144));
        colorMap.put("Al", new Color(128, 128, 144));
        colorMap.put("Ti", new Color(128, 128, 144));
        colorMap.put("Cr", new Color(128, 128, 144));
        colorMap.put("Ag", new Color(128, 128, 144));
        colorMap.put("F", new Color(218, 165, 32));
        colorMap.put("Si", new Color(218, 165, 32));
        colorMap.put("Au", new Color(218, 165, 32));
        colorMap.put("I", new Color(160, 32, 240));
        colorMap.put("Li", new Color(178, 34, 34));
        colorMap.put("He", new Color(255, 192, 203));
    }
}

