/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.HBondAcceptorCountDescriptorTest")
public class HBondAcceptorCountDescriptor
implements IMolecularDescriptor {
    private boolean checkAromaticity = false;
    private static final String[] names = new String[]{"nHBAcc"};

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#hBondacceptors", this.getClass().getName(), "$Id: 4008abdd0c04bf8ddb4f421f3defff4689ff1fa8 $", "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("HBondAcceptorCountDescriptor expects a single parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), e);
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        IAtomContainer ac;
        int hBondAcceptors = 0;
        try {
            ac = atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(e);
        }
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(ac);
                CDKHueckelAromaticityDetector.detectAromaticity(ac);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
        }
        block4: for (int atomIndex = 0; atomIndex < ac.getAtomCount(); ++atomIndex) {
            List<IAtom> neighbours;
            if (ac.getAtom(atomIndex).getSymbol().equals("N") && ac.getAtom(atomIndex).getFormalCharge() <= 0) {
                neighbours = ac.getConnectedAtomsList(ac.getAtom(atomIndex));
                for (IAtom neighbour : neighbours) {
                    if (!neighbour.getSymbol().equals("O")) continue;
                    continue block4;
                }
                ++hBondAcceptors;
            }
            if (!ac.getAtom(atomIndex).getSymbol().equals("O") || ac.getAtom(atomIndex).getFormalCharge() > 0) continue;
            neighbours = ac.getConnectedAtomsList(ac.getAtom(atomIndex));
            for (IAtom neighbour : neighbours) {
                if (!neighbour.getSymbol().equals("N") && (!neighbour.getSymbol().equals("C") || !neighbour.getFlag(32))) continue;
                continue block4;
            }
            ++hBondAcceptors;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(hBondAcceptors), this.getDescriptorNames());
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return false;
    }
}

