/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.charges.Electronegativity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.SigmaElectronegativityDescriptorTest")
public class SigmaElectronegativityDescriptor
implements IAtomicDescriptor {
    private int maxIterations = 0;
    private static final String[] descriptorNames = new String[]{"elecSigmA"};
    private Electronegativity electronegativity = new Electronegativity();

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#sigmaElectronegativity", this.getClass().getName(), "$Id: c886053415c175b9d8baad43850b91f2aeb1beaf $", "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("SigmaElectronegativityDescriptor only expects one parameter");
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter must be of type Integer");
        }
        if (params.length == 0) {
            return;
        }
        this.maxIterations = (Integer)params[0];
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.maxIterations};
        return params;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return descriptorNames;
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom atom, IAtomContainer ac) {
        IAtom localAtom;
        IAtomContainer clone;
        try {
            clone = ac.clone();
            localAtom = clone.getAtom(ac.getAtomNumber(atom));
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(clone);
        }
        catch (CDKException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), descriptorNames, e);
        }
        catch (CloneNotSupportedException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), descriptorNames, e);
        }
        if (this.maxIterations != -1 && this.maxIterations != 0) {
            this.electronegativity.setMaxIterations(this.maxIterations);
        }
        double result = this.electronegativity.calculateSigmaElectronegativity(clone, localAtom);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(result), descriptorNames);
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"maxIterations"};
        return params;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return 0;
    }
}

