/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.charges.PiElectronegativity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.LonePairElectronChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.PiElectronegativityDescriptorTest")
public class PiElectronegativityDescriptor
implements IAtomicDescriptor {
    private int maxIterations = -1;
    private int maxResonStruc = -1;
    private boolean lpeChecker = true;
    private static final String[] descriptorNames = new String[]{"elecPiA"};
    private PiElectronegativity electronegativity = new PiElectronegativity();

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#piElectronegativity", this.getClass().getName(), "$Id: 465b51ada42e754a6b317ce64147ed06fe11b69a $", "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 3) {
            throw new CDKException("PartialPiChargeDescriptor only expects three parameter");
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter must be of type Integer");
        }
        this.maxIterations = (Integer)params[0];
        if (params.length > 1 && params[1] != null) {
            if (!(params[1] instanceof Boolean)) {
                throw new CDKException("The parameter must be of type Boolean");
            }
            this.lpeChecker = (Boolean)params[1];
        }
        if (params.length > 2 && params[2] != null) {
            if (!(params[2] instanceof Integer)) {
                throw new CDKException("The parameter must be of type Integer");
            }
            this.maxResonStruc = (Integer)params[2];
        }
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.maxIterations, this.lpeChecker, this.maxResonStruc};
        return params;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return descriptorNames;
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom atom, IAtomContainer atomContainer) {
        IAtom localAtom;
        IAtomContainer clone;
        try {
            clone = atomContainer.clone();
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(clone);
            if (this.lpeChecker) {
                LonePairElectronChecker lpcheck = new LonePairElectronChecker();
                lpcheck.saturate(atomContainer);
            }
            localAtom = clone.getAtom(atomContainer.getAtomNumber(atom));
        }
        catch (CloneNotSupportedException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), descriptorNames, null);
        }
        catch (CDKException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), descriptorNames, null);
        }
        if (this.maxIterations != -1 && this.maxIterations != 0) {
            this.electronegativity.setMaxIterations(this.maxIterations);
        }
        if (this.maxResonStruc != -1 && this.maxResonStruc != 0) {
            this.electronegativity.setMaxResonStruc(this.maxResonStruc);
        }
        double result = this.electronegativity.calculatePiElectronegativity(clone, localAtom);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(result), descriptorNames);
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"maxIterations", "lpeChecker", "maxResonStruc"};
        return params;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        if ("maxIterations".equals(name)) {
            return Integer.MAX_VALUE;
        }
        if ("lpeChecker".equals(name)) {
            return Boolean.TRUE;
        }
        if ("maxResonStruc".equals(name)) {
            return Integer.MAX_VALUE;
        }
        return null;
    }
}

