/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.GhemicalMMFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.io.GhemicalMMReaderTest")
public class GhemicalMMReader
extends DefaultChemObjectReader {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(GhemicalMMReader.class);
    private BufferedReader input = null;

    public GhemicalMMReader(Reader input) {
        this.input = new BufferedReader(input);
    }

    public GhemicalMMReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public GhemicalMMReader() {
        this(new StringReader(""));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return GhemicalMMFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @Override
    @TestMethod(value="testClose")
    public void close() {
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        if (IChemFile.class.equals((Object)classObject)) {
            return true;
        }
        if (IChemModel.class.equals((Object)classObject)) {
            return true;
        }
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IChemModel.class.equals(interfaces[i])) {
                return true;
            }
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemModel) {
            return (T)this.readChemModel((IChemModel)object);
        }
        if (object instanceof IChemFile) {
            IChemSequence sequence = object.getBuilder().newInstance(IChemSequence.class, new Object[0]);
            sequence.addChemModel(this.readChemModel(object.getBuilder().newInstance(IChemModel.class, new Object[0])));
            ((IChemFile)object).addChemSequence(sequence);
            return object;
        }
        throw new CDKException("Only supported is ChemModel.");
    }

    private IChemModel readChemModel(IChemModel model) throws CDKException {
        int[] atoms = new int[1];
        double[] atomxs = new double[1];
        double[] atomys = new double[1];
        double[] atomzs = new double[1];
        double[] atomcharges = new double[1];
        int[] bondatomid1 = new int[1];
        int[] bondatomid2 = new int[1];
        IBond.Order[] bondorder = new IBond.Order[1];
        int numberOfAtoms = 0;
        int numberOfBonds = 0;
        try {
            String line = this.input.readLine();
            while (line != null) {
                int atomID;
                StringTokenizer atomInfoFields;
                StringTokenizer st = new StringTokenizer(line);
                String command = st.nextToken();
                if ("!Header".equals(command)) {
                    logger.warn("Ignoring header");
                } else if ("!Info".equals(command)) {
                    logger.warn("Ignoring info");
                } else if ("!Atoms".equals(command)) {
                    logger.info("Reading atom block");
                    try {
                        numberOfAtoms = Integer.parseInt(st.nextToken());
                        logger.debug("  #atoms: " + numberOfAtoms);
                        atoms = new int[numberOfAtoms];
                        atomxs = new double[numberOfAtoms];
                        atomys = new double[numberOfAtoms];
                        atomzs = new double[numberOfAtoms];
                        atomcharges = new double[numberOfAtoms];
                        for (int i = 0; i < numberOfAtoms; ++i) {
                            line = this.input.readLine();
                            atomInfoFields = new StringTokenizer(line);
                            atomID = Integer.parseInt(atomInfoFields.nextToken());
                            atoms[atomID] = Integer.parseInt(atomInfoFields.nextToken());
                            logger.debug("Set atomic number of atom (" + atomID + ") to: " + atoms[atomID]);
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Error while reading Atoms block");
                        logger.debug(exception);
                    }
                } else if ("!Bonds".equals(command)) {
                    logger.info("Reading bond block");
                    try {
                        numberOfBonds = Integer.parseInt(st.nextToken());
                        bondatomid1 = new int[numberOfAtoms];
                        bondatomid2 = new int[numberOfAtoms];
                        bondorder = new IBond.Order[numberOfAtoms];
                        for (int i = 0; i < numberOfBonds; ++i) {
                            line = this.input.readLine();
                            StringTokenizer bondInfoFields = new StringTokenizer(line);
                            bondatomid1[i] = Integer.parseInt(bondInfoFields.nextToken());
                            bondatomid2[i] = Integer.parseInt(bondInfoFields.nextToken());
                            String order = bondInfoFields.nextToken();
                            if ("D".equals(order)) {
                                bondorder[i] = IBond.Order.DOUBLE;
                                continue;
                            }
                            if ("S".equals(order)) {
                                bondorder[i] = IBond.Order.SINGLE;
                                continue;
                            }
                            if ("T".equals(order)) {
                                bondorder[i] = IBond.Order.TRIPLE;
                                continue;
                            }
                            logger.warn("Unrecognized bond order, using single bond instead. Found: " + order);
                            bondorder[i] = IBond.Order.SINGLE;
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Error while reading Bonds block");
                        logger.debug(exception);
                    }
                } else if ("!Coord".equals(command)) {
                    logger.info("Reading coordinate block");
                    try {
                        for (int i = 0; i < numberOfAtoms; ++i) {
                            line = this.input.readLine();
                            atomInfoFields = new StringTokenizer(line);
                            atomID = Integer.parseInt(atomInfoFields.nextToken());
                            double x = Double.valueOf(atomInfoFields.nextToken());
                            double y = Double.valueOf(atomInfoFields.nextToken());
                            double z = Double.valueOf(atomInfoFields.nextToken());
                            atomxs[atomID] = x;
                            atomys[atomID] = y;
                            atomzs[atomID] = z;
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Error while reading Coord block");
                        logger.debug(exception);
                    }
                } else if ("!Charges".equals(command)) {
                    logger.info("Reading charges block");
                    try {
                        for (int i = 0; i < numberOfAtoms; ++i) {
                            double charge;
                            line = this.input.readLine();
                            atomInfoFields = new StringTokenizer(line);
                            atomID = Integer.parseInt(atomInfoFields.nextToken());
                            atomcharges[atomID] = charge = Double.valueOf(atomInfoFields.nextToken()).doubleValue();
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Error while reading Charges block");
                        logger.debug(exception);
                    }
                } else {
                    if ("!End".equals(command)) {
                        int i;
                        logger.info("Found end of file");
                        IAtomContainer container = model.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                        for (i = 0; i < numberOfAtoms; ++i) {
                            try {
                                IAtom atom = model.getBuilder().newInstance(IAtom.class, IsotopeFactory.getInstance(container.getBuilder()).getElementSymbol(atoms[i]));
                                atom.setAtomicNumber(atoms[i]);
                                atom.setPoint3d(new Point3d(atomxs[i], atomys[i], atomzs[i]));
                                atom.setCharge(atomcharges[i]);
                                container.addAtom(atom);
                                logger.debug("Stored atom: " + atom);
                                continue;
                            }
                            catch (Exception exception) {
                                logger.error("Cannot create an atom with atomic number: " + atoms[i]);
                                logger.debug(exception);
                            }
                        }
                        for (i = 0; i < numberOfBonds; ++i) {
                            container.addBond(bondatomid1[i], bondatomid2[i], bondorder[i]);
                        }
                        IAtomContainerSet moleculeSet = model.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                        moleculeSet.addAtomContainer(model.getBuilder().newInstance(IAtomContainer.class, container));
                        model.setMoleculeSet(moleculeSet);
                        return model;
                    }
                    logger.warn("Skipping line: " + line);
                }
                line = this.input.readLine();
            }
        }
        catch (Exception exception) {
            logger.error("Error while reading file");
            logger.debug(exception);
        }
        return null;
    }
}

