/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.inchi;

import java.util.List;
import net.sf.jniinchi.INCHI_OPTION;
import net.sf.jniinchi.JniInchiWrapper;
import net.sf.jniinchi.LoadNativeLibraryException;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.InChIGenerator;
import org.openscience.cdk.inchi.InChIToStructure;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InChIGeneratorFactory {
    private static InChIGeneratorFactory INSTANCE;

    private InChIGeneratorFactory() throws CDKException {
        try {
            JniInchiWrapper.loadLibrary();
        }
        catch (LoadNativeLibraryException lnle) {
            throw new CDKException("Unable to load native code; " + lnle.getMessage(), lnle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InChIGeneratorFactory getInstance() throws CDKException {
        Class<InChIGeneratorFactory> clazz = InChIGeneratorFactory.class;
        synchronized (InChIGeneratorFactory.class) {
            if (INSTANCE == null) {
                INSTANCE = new InChIGeneratorFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public InChIGenerator getInChIGenerator(IAtomContainer container) throws CDKException {
        return new InChIGenerator(container);
    }

    public InChIGenerator getInChIGenerator(IAtomContainer container, String options) throws CDKException {
        return new InChIGenerator(container, options);
    }

    public InChIGenerator getInChIGenerator(IAtomContainer container, List<INCHI_OPTION> options) throws CDKException {
        return new InChIGenerator(container, options);
    }

    public InChIToStructure getInChIToStructure(String inchi, IChemObjectBuilder builder) throws CDKException {
        return new InChIToStructure(inchi, builder);
    }

    public InChIToStructure getInChIToStructure(String inchi, IChemObjectBuilder builder, String options) throws CDKException {
        return new InChIToStructure(inchi, builder, options);
    }

    public InChIToStructure getInChIToStructure(String inchi, IChemObjectBuilder builder, List<String> options) throws CDKException {
        return new InChIToStructure(inchi, builder, options);
    }
}

