/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.signature;

import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import signature.AbstractVertexSignature;

@TestClass(value="org.openscience.cdk.signature.AtomSignatureTest")
public class AtomSignature
extends AbstractVertexSignature {
    private IAtomContainer molecule;

    public AtomSignature(int atomIndex, IAtomContainer molecule) {
        this.molecule = molecule;
        super.createMaximumHeight(atomIndex, molecule.getAtomCount());
    }

    public AtomSignature(IAtom atom, IAtomContainer molecule) {
        this(molecule.getAtomNumber(atom), molecule);
    }

    public AtomSignature(int atomIndex, int height, IAtomContainer molecule) {
        this.molecule = molecule;
        super.create(atomIndex, molecule.getAtomCount(), height);
    }

    public AtomSignature(IAtom atom, int height, IAtomContainer molecule) {
        this(molecule.getAtomNumber(atom), height, molecule);
    }

    public AtomSignature(int atomIndex, int height, AbstractVertexSignature.InvariantType invariantType, IAtomContainer molecule) {
        super(invariantType);
        this.molecule = molecule;
        super.create(atomIndex, molecule.getAtomCount(), height);
    }

    public AtomSignature(IAtom atom, int height, AbstractVertexSignature.InvariantType invariantType, IAtomContainer molecule) {
        this(molecule.getAtomNumber(atom), height, invariantType, molecule);
    }

    @Override
    @TestMethod(value="getIntLabelTest")
    protected int getIntLabel(int vertexIndex) {
        IAtom atom = this.molecule.getAtom(vertexIndex);
        return atom.getMassNumber();
    }

    @Override
    @TestMethod(value="getConnectedTest")
    protected int[] getConnected(int vertexIndex) {
        IAtom atom = this.molecule.getAtom(vertexIndex);
        List<IAtom> connected = this.molecule.getConnectedAtomsList(atom);
        int[] connectedIndices = new int[connected.size()];
        int indexCounter = 0;
        for (IAtom otherAtom : connected) {
            connectedIndices[indexCounter++] = this.molecule.getAtomNumber(otherAtom);
        }
        return connectedIndices;
    }

    @Override
    @TestMethod(value="getEdgeLabelTest,getAromaticEdgeLabelTest")
    protected String getEdgeLabel(int vertexIndex, int otherVertexIndex) {
        IAtom atomB;
        IAtom atomA = this.molecule.getAtom(vertexIndex);
        IBond bond = this.molecule.getBond(atomA, atomB = this.molecule.getAtom(otherVertexIndex));
        if (bond != null) {
            if (bond.getFlag(5)) {
                return "p";
            }
            switch (bond.getOrder()) {
                case SINGLE: {
                    return "";
                }
                case DOUBLE: {
                    return "=";
                }
                case TRIPLE: {
                    return "#";
                }
                case QUADRUPLE: {
                    return "$";
                }
            }
            return "";
        }
        return "";
    }

    @Override
    @TestMethod(value="getVertexSymbolTest")
    protected String getVertexSymbol(int vertexIndex) {
        return this.molecule.getAtom(vertexIndex).getSymbol();
    }
}

