/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.modeling.builder3d;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.FingerprinterTool;
import org.openscience.cdk.fingerprint.HybridizationFingerprinter;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.io.iterator.IteratingMDLReader;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.nonotify.NoNotificationChemObjectBuilder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class TemplateHandler3D {
    private static final IChemObjectBuilder builder = NoNotificationChemObjectBuilder.getInstance();
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(TemplateHandler3D.class);
    IMolecule molecule;
    IRingSet sssr;
    IMoleculeSet templates = builder.newInstance(IMoleculeSet.class, new Object[0]);
    List<BitSet> fingerprintData = new ArrayList<BitSet>();
    private boolean templatesLoaded = false;
    private static TemplateHandler3D self = null;

    private TemplateHandler3D() {
    }

    public static TemplateHandler3D getInstance() throws CDKException {
        if (self == null) {
            self = new TemplateHandler3D();
        }
        return self;
    }

    private void loadTemplates() throws CDKException {
        IMolecule molecule;
        IteratingMDLReader imdl;
        BufferedReader fin;
        InputStream ins;
        logger.debug("Loading templates...");
        try {
            ins = this.getClass().getClassLoader().getResourceAsStream("org/openscience/cdk/modeling/builder3d/data/ringTemplateStructures.sdf.gz");
            fin = new BufferedReader(new InputStreamReader(new GZIPInputStream(ins)));
            imdl = new IteratingMDLReader(fin, builder);
        }
        catch (IOException exc1) {
            throw new CDKException("Problems loading file ringTemplateStructures.sdf.gz", exc1);
        }
        while (imdl.hasNext()) {
            molecule = (IMolecule)imdl.next();
            this.templates.addMolecule(molecule);
        }
        molecule = null;
        try {
            imdl.close();
        }
        catch (Exception exc2) {
            System.out.println("Could not close Reader due to: " + exc2.getMessage());
        }
        try {
            ins = this.getClass().getClassLoader().getResourceAsStream("org/openscience/cdk/modeling/builder3d/data/ringTemplateFingerprints.txt.gz");
            fin = new BufferedReader(new InputStreamReader(new GZIPInputStream(ins)));
        }
        catch (Exception exc3) {
            throw new CDKException("Could not read Fingerprints from FingerprintFile due to: " + exc3.getMessage(), exc3);
        }
        String s = null;
        while (true) {
            try {
                s = fin.readLine();
            }
            catch (Exception exc4) {
                throw new CDKException("Error while reading the fingerprints: " + exc4.getMessage(), exc4);
            }
            if (s == null) break;
            try {
                this.fingerprintData.add(TemplateHandler3D.getBitSetFromFile(new StringTokenizer(s, "\t ;{, }")));
            }
            catch (Exception exception) {
                throw new CDKException("Error while reading the fingerprints: " + exception.getMessage(), exception);
            }
        }
        this.templatesLoaded = true;
    }

    public static BitSet getBitSetFromFile(StringTokenizer st) throws Exception {
        BitSet bitSet = new BitSet(1024);
        while (st.hasMoreTokens()) {
            bitSet.set(Integer.parseInt(st.nextToken()));
        }
        return bitSet;
    }

    public IRingSet getLargestRingSet(List<IRingSet> ringSystems) {
        IRingSet largestRingSet = null;
        int atomNumber = 0;
        IAtomContainer container = null;
        for (int i = 0; i < ringSystems.size(); ++i) {
            container = this.getAllInOneContainer(ringSystems.get(i));
            if (atomNumber >= container.getAtomCount()) continue;
            atomNumber = container.getAtomCount();
            largestRingSet = ringSystems.get(i);
        }
        return largestRingSet;
    }

    private IAtomContainer getAllInOneContainer(IRingSet ringSet) {
        IAtomContainer resultContainer = ringSet.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        Iterator<IAtomContainer> containers = RingSetManipulator.getAllAtomContainers(ringSet).iterator();
        while (containers.hasNext()) {
            resultContainer.add(containers.next());
        }
        return resultContainer;
    }

    public void mapTemplates(IAtomContainer ringSystems, double NumberOfRingAtoms) throws CDKException, CloneNotSupportedException {
        if (!this.templatesLoaded) {
            self.loadTemplates();
        }
        IAtomContainer ringSystemAnyBondAnyAtom = AtomContainerManipulator.createAllCarbonAllSingleNonAromaticBondAtomContainer(ringSystems);
        BitSet ringSystemFingerprint = new HybridizationFingerprinter().getFingerprint(ringSystemAnyBondAnyAtom);
        boolean flagMaxSubstructure = false;
        boolean flagSecondbest = false;
        for (int i = 0; i < this.fingerprintData.size(); ++i) {
            IAtomContainer templateAnyBondAnyAtom;
            IMolecule template = this.templates.getMolecule(i);
            if (template.getAtomCount() != ringSystems.getAtomCount() || !FingerprinterTool.isSubset(this.fingerprintData.get(i), ringSystemFingerprint) || !UniversalIsomorphismTester.isSubgraph(ringSystemAnyBondAnyAtom, templateAnyBondAnyAtom = AtomContainerManipulator.createAllCarbonAllSingleNonAromaticBondAtomContainer(template))) continue;
            List<RMap> list = UniversalIsomorphismTester.getSubgraphAtomsMap(ringSystemAnyBondAnyAtom, templateAnyBondAnyAtom);
            boolean flagwritefromsecondbest = false;
            if (NumberOfRingAtoms / (double)list.size() == 1.0 && templateAnyBondAnyAtom.getBondCount() == ringSystems.getBondCount()) {
                if (UniversalIsomorphismTester.isSubgraph(ringSystems, template)) {
                    flagMaxSubstructure = true;
                    list = UniversalIsomorphismTester.getSubgraphAtomsMap(ringSystems, template);
                } else {
                    flagSecondbest = true;
                    flagwritefromsecondbest = true;
                }
            }
            if (!flagSecondbest || flagMaxSubstructure || flagwritefromsecondbest) {
                for (int j = 0; j < list.size(); ++j) {
                    RMap map = list.get(j);
                    IAtom atom1 = ringSystems.getAtom(map.getId1());
                    IAtom atom2 = template.getAtom(map.getId2());
                    if (!atom1.getFlag(1)) continue;
                    atom1.setPoint3d(new Point3d(atom2.getPoint3d()));
                }
            }
            if (flagMaxSubstructure) break;
        }
        if (!flagMaxSubstructure) {
            System.out.println("WARNING: Maybe RingTemplateError!");
        }
    }

    public int getTemplateCount() {
        return this.templates.getMoleculeCount();
    }

    public IAtomContainer getTemplateAt(int position) {
        return this.templates.getMolecule(position);
    }
}

