/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.math;

import java.util.Random;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

@TestClass(value="org.openscience.cdk.math.RandomNumbersToolTest")
public class RandomNumbersTool
extends Random {
    private static final long serialVersionUID = -8238833473383641882L;
    private static Random random;
    private static long randomSeed;

    @TestMethod(value="testSetRandom")
    public static void setRandom(Random base_random) {
        random = base_random;
    }

    @TestMethod(value="testSetRandomSeed_long")
    public static void setRandomSeed(long new_seed) {
        randomSeed = new_seed;
        random.setSeed(randomSeed);
    }

    @TestMethod(value="testGetRandomSeed")
    public static long getRandomSeed() {
        return randomSeed;
    }

    @TestMethod(value="testSetRandom")
    public static Random getRandom() {
        return random;
    }

    @TestMethod(value="testRandomInt")
    public static int randomInt() {
        return RandomNumbersTool.randomInt(0, 1);
    }

    @TestMethod(value="testRandomInt_int_int")
    public static int randomInt(int lo, int hi) {
        return Math.abs(random.nextInt()) % (hi - lo + 1) + lo;
    }

    @TestMethod(value="testRandomLong")
    public static long randomLong() {
        return RandomNumbersTool.randomLong(0L, 1L);
    }

    @TestMethod(value="testRandomLong_long_long")
    public static long randomLong(long lo, long hi) {
        return Math.abs(random.nextLong()) % (hi - lo + 1L) + lo;
    }

    @TestMethod(value="testRandomFloat")
    public static float randomFloat() {
        return random.nextFloat();
    }

    @TestMethod(value="testRandomFloat_float_float")
    public static float randomFloat(float lo, float hi) {
        return (hi - lo) * random.nextFloat() + lo;
    }

    @TestMethod(value="testRandomDouble")
    public static double randomDouble() {
        return random.nextDouble();
    }

    @TestMethod(value="testRandomDouble_double_double")
    public static double randomDouble(double lo, double hi) {
        return (hi - lo) * random.nextDouble() + lo;
    }

    @TestMethod(value="testRandomBoolean")
    public static boolean randomBoolean() {
        return RandomNumbersTool.randomInt() == 1;
    }

    @TestMethod(value="testRandomBit")
    public static int randomBit() {
        return RandomNumbersTool.randomInt();
    }

    @TestMethod(value="testFlipCoin")
    public static boolean flipCoin(double p) {
        return RandomNumbersTool.randomDouble() < p;
    }

    @TestMethod(value="testGaussianFloat")
    public static float gaussianFloat(float dev) {
        return (float)random.nextGaussian() * dev;
    }

    @TestMethod(value="testGaussianDouble")
    public static double gaussianDouble(double dev) {
        return random.nextGaussian() * dev;
    }

    @TestMethod(value="testExponentialDouble")
    public static double exponentialDouble(double mean) {
        return -mean * Math.log(RandomNumbersTool.randomDouble());
    }

    static {
        randomSeed = System.currentTimeMillis();
        random = new Random(randomSeed);
    }
}

