/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.traverse.BreadthFirstIterator;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

@TestClass(value="org.openscience.cdk.graph.BFSShortestPathTest")
public final class BFSShortestPath {
    private BFSShortestPath() {
    }

    @TestMethod(value="testFindPathBetween_Graph_Object_Object")
    public static List<Edge> findPathBetween(Graph graph, Object startVertex, Object endVertex) {
        MyBreadthFirstIterator iter = new MyBreadthFirstIterator(graph, startVertex);
        while (iter.hasNext()) {
            Object vertex = iter.next();
            if (!vertex.equals(endVertex)) continue;
            return BFSShortestPath.createPath(iter, endVertex);
        }
        return null;
    }

    private static List<Edge> createPath(MyBreadthFirstIterator iter, Object endVertex) {
        Edge edge;
        ArrayList<Edge> path = new ArrayList<Edge>();
        while ((edge = iter.getSpanningTreeEdge(endVertex)) != null) {
            path.add(edge);
            endVertex = edge.oppositeVertex(endVertex);
        }
        Collections.reverse(path);
        return path;
    }

    private static class MyBreadthFirstIterator
    extends BreadthFirstIterator {
        public MyBreadthFirstIterator(Graph g, Object startVertex) {
            super(g, startVertex);
        }

        @Override
        protected void encounterVertex(Object vertex, Edge edge) {
            super.encounterVertex(vertex, edge);
            this.putSeenData(vertex, edge);
        }

        public Edge getSpanningTreeEdge(Object vertex) {
            return (Edge)this.getSeenData(vertex);
        }
    }
}

